/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotatedMethod {
    private final Method method;
    private final Method bridgedMethod;
    private final MethodParameter[] parameters;
    @Nullable
    private volatile List<Annotation[][]> inheritedParameterAnnotations;

    public AnnotatedMethod(Method method) {
        Assert.notNull((Object)method, "Method is required");
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod(method);
        ReflectionUtils.makeAccessible(this.bridgedMethod);
        this.parameters = this.initMethodParameters();
    }

    protected AnnotatedMethod(AnnotatedMethod annotatedMethod) {
        Assert.notNull((Object)annotatedMethod, "AnnotatedMethod is required");
        this.method = annotatedMethod.method;
        this.bridgedMethod = annotatedMethod.bridgedMethod;
        this.parameters = annotatedMethod.parameters;
        this.inheritedParameterAnnotations = annotatedMethod.inheritedParameterAnnotations;
    }

    public final Method getMethod() {
        return this.method;
    }

    protected final Method getBridgedMethod() {
        return this.bridgedMethod;
    }

    protected Class<?> getContainingClass() {
        return this.method.getDeclaringClass();
    }

    public final MethodParameter[] getMethodParameters() {
        return this.parameters;
    }

    private MethodParameter[] initMethodParameters() {
        int count = this.bridgedMethod.getParameterCount();
        MethodParameter[] result = new MethodParameter[count];
        for (int i2 = 0; i2 < count; ++i2) {
            result[i2] = new AnnotatedMethodParameter(i2);
        }
        return result;
    }

    public MethodParameter getReturnType() {
        return new AnnotatedMethodParameter(-1);
    }

    public MethodParameter getReturnValueType(@Nullable Object returnValue) {
        return new ReturnValueMethodParameter(returnValue);
    }

    public boolean isVoid() {
        return this.getReturnType().getParameterType() == Void.TYPE;
    }

    @Nullable
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return AnnotatedElementUtils.findMergedAnnotation(this.method, annotationType);
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
        return AnnotatedElementUtils.hasAnnotation(this.method, annotationType);
    }

    private List<Annotation[][]> getInheritedParameterAnnotations() {
        List<Annotation[][]> parameterAnnotations = this.inheritedParameterAnnotations;
        if (parameterAnnotations == null) {
            parameterAnnotations = new ArrayList<Annotation[][]>();
            Class<?> clazz = this.method.getDeclaringClass();
            while (clazz != null) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    for (Method candidate : clazz2.getMethods()) {
                        if (!this.isOverrideFor(candidate)) continue;
                        parameterAnnotations.add(candidate.getParameterAnnotations());
                    }
                }
                if ((clazz = clazz.getSuperclass()) == Object.class) {
                    clazz = null;
                }
                if (clazz == null) continue;
                for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                    if (!this.isOverrideFor((Method)genericDeclaration)) continue;
                    parameterAnnotations.add(((Method)genericDeclaration).getParameterAnnotations());
                }
            }
            this.inheritedParameterAnnotations = parameterAnnotations;
        }
        return parameterAnnotations;
    }

    private boolean isOverrideFor(Method candidate) {
        if (Modifier.isPrivate(candidate.getModifiers()) || !candidate.getName().equals(this.method.getName()) || candidate.getParameterCount() != this.method.getParameterCount()) {
            return false;
        }
        Object[] paramTypes = this.method.getParameterTypes();
        if (Arrays.equals(candidate.getParameterTypes(), paramTypes)) {
            return true;
        }
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (paramTypes[i2] == ResolvableType.forMethodParameter(candidate, i2, this.method.getDeclaringClass()).toClass()) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AnnotatedMethod)) return false;
        AnnotatedMethod otherHandlerMethod = (AnnotatedMethod)other;
        if (!this.method.equals(otherHandlerMethod.method)) return false;
        return true;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return this.method.toGenericString();
    }

    @Nullable
    protected static Object findProvidedArgument(MethodParameter parameter, Object ... providedArgs) {
        if (!ObjectUtils.isEmpty(providedArgs)) {
            for (Object providedArg : providedArgs) {
                if (!parameter.getParameterType().isInstance(providedArg)) continue;
                return providedArg;
            }
        }
        return null;
    }

    protected static String formatArgumentError(MethodParameter param, String message) {
        return "Could not resolve parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (String)(StringUtils.hasText(message) ? ": " + message : "");
    }

    protected class AnnotatedMethodParameter
    extends SynthesizingMethodParameter {
        @Nullable
        private volatile Annotation[] combinedAnnotations;

        public AnnotatedMethodParameter(int index) {
            super(AnnotatedMethod.this.getBridgedMethod(), index);
        }

        protected AnnotatedMethodParameter(AnnotatedMethodParameter original) {
            super(original);
            this.combinedAnnotations = original.combinedAnnotations;
        }

        @Override
        @NonNull
        public Method getMethod() {
            return AnnotatedMethod.this.getBridgedMethod();
        }

        @Override
        public Class<?> getContainingClass() {
            return AnnotatedMethod.this.getContainingClass();
        }

        @Nullable
        public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
            return AnnotatedMethod.this.getMethodAnnotation(annotationType);
        }

        public <T extends Annotation> boolean hasMethodAnnotation(Class<T> annotationType) {
            return AnnotatedMethod.this.hasMethodAnnotation(annotationType);
        }

        @Override
        public Annotation[] getParameterAnnotations() {
            Annotation[] anns = this.combinedAnnotations;
            if (anns == null) {
                anns = super.getParameterAnnotations();
                int index = this.getParameterIndex();
                if (index >= 0) {
                    for (Annotation[][] ifcAnns : AnnotatedMethod.this.getInheritedParameterAnnotations()) {
                        Annotation[] paramAnns;
                        if (index >= ifcAnns.length || (paramAnns = ifcAnns[index]).length <= 0) continue;
                        ArrayList<Annotation> merged = new ArrayList<Annotation>(anns.length + paramAnns.length);
                        merged.addAll(Arrays.asList(anns));
                        for (Annotation paramAnn : paramAnns) {
                            boolean existingType = false;
                            for (Annotation ann : anns) {
                                if (ann.annotationType() != paramAnn.annotationType()) continue;
                                existingType = true;
                                break;
                            }
                            if (existingType) continue;
                            merged.add(this.adaptAnnotation(paramAnn));
                        }
                        anns = merged.toArray(new Annotation[0]);
                    }
                }
                this.combinedAnnotations = anns;
            }
            return anns;
        }

        @Override
        public AnnotatedMethodParameter clone() {
            return new AnnotatedMethodParameter(this);
        }
    }

    private class ReturnValueMethodParameter
    extends AnnotatedMethodParameter {
        @Nullable
        private final Class<?> returnValueType;

        public ReturnValueMethodParameter(Object returnValue) {
            super(-1);
            this.returnValueType = returnValue != null ? returnValue.getClass() : null;
        }

        protected ReturnValueMethodParameter(ReturnValueMethodParameter original) {
            super(original);
            this.returnValueType = original.returnValueType;
        }

        @Override
        public Class<?> getParameterType() {
            return this.returnValueType != null ? this.returnValueType : super.getParameterType();
        }

        @Override
        public ReturnValueMethodParameter clone() {
            return new ReturnValueMethodParameter(this);
        }
    }
}

