/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.JavaExpression;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JqExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.VariableExpression;
import org.apache.camel.model.language.WasmExpression;
import org.apache.camel.util.ObjectHelper;

public final class Builder {
    private Builder() {
    }

    public static ValueBuilder method(Object beanOrBeanRef) {
        return Builder.method(beanOrBeanRef, null);
    }

    public static ValueBuilder method(Object beanOrBeanRef, String method) {
        MethodCallExpression exp;
        if (beanOrBeanRef instanceof String) {
            String str = (String)beanOrBeanRef;
            exp = new MethodCallExpression(str, method);
        } else {
            exp = new MethodCallExpression(beanOrBeanRef, method);
        }
        return new ValueBuilder(exp);
    }

    public static ValueBuilder method(Class<?> beanType, String method) {
        MethodCallExpression exp = new MethodCallExpression(beanType, method);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder constant(Object value) {
        ConstantExpression exp;
        if (value instanceof String) {
            String str = (String)value;
            exp = new ConstantExpression(str);
        } else {
            ConstantExpression ce = new ConstantExpression();
            ExpressionDefinition def = ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)value));
            ce.setExpressionType(def);
            ce.setExpression(String.valueOf(value));
            exp = ce;
        }
        return new ValueBuilder(exp);
    }

    public static ValueBuilder constant(String value, Class<?> resultType) {
        ConstantExpression exp = new ConstantExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder constant(Object value, boolean trim) {
        ConstantExpression exp;
        if (value instanceof String) {
            String str = (String)value;
            ConstantExpression ce = new ConstantExpression(str);
            ce.setTrim(trim ? "true" : "false");
            exp = ce;
        } else {
            ConstantExpression ce = new ConstantExpression();
            ce.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)value)));
            ce.setExpression(String.valueOf(value));
            ce.setTrim(trim ? "true" : "false");
            exp = ce;
        }
        return new ValueBuilder(exp);
    }

    public static ValueBuilder language(String language, String expression) {
        LanguageExpression exp = new LanguageExpression(language, expression);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder csimple(String value) {
        CSimpleExpression exp = new CSimpleExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder csimple(String value, Class<?> resultType) {
        CSimpleExpression exp = new CSimpleExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder simple(String value) {
        SimpleExpression exp = new SimpleExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder simple(String value, Class<?> resultType) {
        SimpleExpression exp = new SimpleExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    @Deprecated(since="4.3.0")
    public static ValueBuilder joor(String value) {
        JoorExpression exp = new JoorExpression(value);
        return new ValueBuilder(exp);
    }

    @Deprecated(since="4.3.0")
    public static ValueBuilder joor(String value, Class<?> resultType) {
        JoorExpression exp = new JoorExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder java(String value) {
        JavaExpression exp = new JavaExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder java(String value, Class<?> resultType) {
        JavaExpression exp = new JavaExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jq(String value) {
        JqExpression exp = new JqExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jq(String value, Class<?> resultType) {
        JqExpression exp = new JqExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jsonpath(String value) {
        JsonPathExpression exp = new JsonPathExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jsonpath(String value, Class<?> resultType) {
        JsonPathExpression exp = new JsonPathExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder header(String name) {
        HeaderExpression exp = new HeaderExpression(name);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder exchangeProperty(String name) {
        ExchangePropertyExpression exp = new ExchangePropertyExpression(name);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder body() {
        SimpleExpression exp = new SimpleExpression("${body}");
        return new ValueBuilder(exp);
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        SimpleExpression exp = new SimpleExpression(String.format("${bodyAs(%s)}", type.getCanonicalName()));
        return new ValueBuilder(exp);
    }

    public static ValueBuilder variable(String name) {
        VariableExpression exp = new VariableExpression(name);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder systemProperty(String name) {
        SimpleExpression exp = new SimpleExpression(String.format("${sys.%s}", name));
        return new ValueBuilder(exp);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return new ValueBuilder(ExpressionBuilder.systemPropertyExpression((String)name, (String)defaultValue));
    }

    public static ValueBuilder exceptionMessage() {
        SimpleExpression exp = new SimpleExpression("${exception.message}");
        return new ValueBuilder(exp);
    }

    public static ValueBuilder exceptionStackTrace() {
        SimpleExpression exp = new SimpleExpression("${exception.stacktrace}");
        return new ValueBuilder(exp);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)content, (String)regex, (String)replacement);
        return new ValueBuilder(newExp);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)content, (String)regex, (Expression)replacement);
        return new ValueBuilder(newExp);
    }

    public static ValueBuilder wasm(String value) {
        WasmExpression exp = new WasmExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder wasm(String value, Class<?> resultType) {
        WasmExpression exp = new WasmExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }
}

