/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.TypeHandlerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionTest {
    OptionTest() {
    }

    private static void checkOption(Option option, String opt, String description, String longOpt, int numArgs, String argName, boolean required, boolean optionalArg, char valueSeparator, Class<?> cls, String deprecatedDesc, Boolean deprecatedForRemoval, String deprecatedSince) {
        Assertions.assertEquals((Object)opt, (Object)option.getOpt());
        Assertions.assertEquals((Object)description, (Object)option.getDescription());
        Assertions.assertEquals((Object)longOpt, (Object)option.getLongOpt());
        Assertions.assertEquals((int)numArgs, (int)option.getArgs());
        Assertions.assertEquals((Object)argName, (Object)option.getArgName());
        Assertions.assertEquals((Object)required, (Object)option.isRequired());
        Assertions.assertEquals((Object)optionalArg, (Object)option.hasOptionalArg());
        Assertions.assertEquals((Object)(numArgs > 0 ? 1 : 0), (Object)option.hasArg());
        Assertions.assertEquals((Object)(numArgs > 0 ? 1 : 0), (Object)option.acceptsArg());
        Assertions.assertEquals((char)valueSeparator, (char)option.getValueSeparator());
        Assertions.assertEquals(cls, (Object)option.getType());
        if (deprecatedDesc != null) {
            Assertions.assertEquals((Object)deprecatedDesc, (Object)option.getDeprecated().getDescription());
        }
        if (deprecatedForRemoval != null) {
            Assertions.assertEquals((Object)deprecatedForRemoval, (Object)option.getDeprecated().isForRemoval());
        }
        if (deprecatedSince != null) {
            Assertions.assertEquals((Object)deprecatedSince, (Object)option.getDeprecated().getSince());
        }
    }

    private Option roundTrip(Option o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (Option)ois.readObject();
    }

    @Test
    void testAddValue() {
        Option option = new Option("f", null);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> option.addValue(""));
        Assertions.assertThrows(IllegalStateException.class, () -> option.processValue(""));
    }

    @Test
    void testBuilderDeprecatedBuildEmpty() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().build());
    }

    @Test
    void testBuilderEmpty() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().get());
    }

    @Test
    void testBuilderInsufficientParams1() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().desc("desc").get());
    }

    @Test
    void testBuilderInsufficientParams2() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder(null).desc("desc").get());
    }

    @Test
    void testBuilderInvalidOptionName0() {
        Assertions.assertThrows(IllegalStateException.class, () -> Option.builder().option(null).get());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder().option(""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder().option(" "));
    }

    @Test
    void testBuilderInvalidOptionName1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder().option("invalid?"));
    }

    @Test
    void testBuilderInvalidOptionName2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder().option("invalid@"));
    }

    @Test
    void testBuilderInvalidOptionName3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder((String)"invalid?"));
    }

    @Test
    void testBuilderInvalidOptionName4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Option.builder((String)"invalid@"));
    }

    @Test
    void testBuilderMethods() {
        boolean defaultSeparator = false;
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").longOpt("aaa").get(), "a", "desc", "aaa", -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(true).get(), "a", "desc", null, 1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(false).get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(true).get(), "a", "desc", null, 1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").numberOfArgs(3).get(), "a", "desc", null, 3, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").required(true).get(), "a", "desc", null, -1, null, true, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").required(false).get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").argName("arg1").get(), "a", "desc", null, -1, "arg1", false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").optionalArg(false).get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").optionalArg(true).get(), "a", "desc", null, 1, null, false, true, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").valueSeparator(':').get(), "a", "desc", null, -1, null, false, false, ':', String.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").type(Integer.class).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, null, null, null);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").type(null).get(), "a", "desc", null, -1, null, false, false, '\u0000', String.class, null, null, null);
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, null, null, null);
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).deprecated().get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, "", false, "");
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).deprecated(DeprecatedAttributes.builder().get()).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, "", false, "");
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).deprecated(DeprecatedAttributes.builder().setDescription("X").get()).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, "X", false, "");
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).deprecated(DeprecatedAttributes.builder().setDescription("X").setForRemoval(true).get()).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, "X", true, "");
        OptionTest.checkOption(Option.builder().option("a").desc("desc").type(Integer.class).deprecated(DeprecatedAttributes.builder().setDescription("X").setForRemoval(true).setSince("2.0").get()).get(), "a", "desc", null, -1, null, false, false, '\u0000', Integer.class, "X", true, "2.0");
    }

    @Test
    void testClear() {
        TestOption option = new TestOption("x", true, "");
        Assertions.assertEquals((int)0, (int)option.getValuesList().size());
        option.addValue("a");
        Assertions.assertEquals((int)1, (int)option.getValuesList().size());
        option.clearValues();
        Assertions.assertEquals((int)0, (int)option.getValuesList().size());
    }

    @Test
    void testClone() {
        TestOption a = new TestOption("a", true, "");
        TestOption b = (TestOption)((Object)a.clone());
        Assertions.assertEquals((Object)((Object)a), (Object)((Object)b));
        Assertions.assertNotSame((Object)((Object)a), (Object)((Object)b));
        a.setDescription("a");
        Assertions.assertEquals((Object)"", (Object)b.getDescription());
        b.setArgs(2);
        b.addValue("b1");
        b.addValue("b2");
        Assertions.assertEquals((int)1, (int)a.getArgs());
        Assertions.assertEquals((int)0, (int)a.getValuesList().size());
        Assertions.assertEquals((int)2, (int)b.getValues().length);
    }

    @Test
    void testEquals() {
        Option option1a = new Option("1", null);
        Option option1b = new Option("1", null);
        Option option2 = new Option("2", null);
        Assertions.assertEquals((Object)option1a, (Object)option1a);
        Assertions.assertEquals((Object)option1a, (Object)option1b);
        Assertions.assertEquals((Object)option1b, (Object)option1a);
        Assertions.assertNotEquals((Object)option1a, (Object)option2);
        Assertions.assertNotEquals((Object)option1b, (Object)option2);
        Assertions.assertNotEquals((Object)option2, (Object)option1a);
        Assertions.assertNotEquals((Object)option2, (Object)"");
    }

    @Test
    void testGetValue() {
        Option option = new Option("f", null);
        option.setArgs(-2);
        Assertions.assertEquals((Object)"default", (Object)option.getValue("default"));
        Assertions.assertNull((Object)option.getValue(0));
        option.processValue("foo");
        Assertions.assertEquals((Object)"foo", (Object)option.getValue());
        Assertions.assertEquals((Object)"foo", (Object)option.getValue(0));
        Assertions.assertEquals((Object)"foo", (Object)option.getValue("default"));
    }

    @Test
    void testHasArgName() {
        Option option = new Option("f", null);
        option.setArgName(null);
        Assertions.assertFalse((boolean)option.hasArgName());
        option.setArgName("");
        Assertions.assertFalse((boolean)option.hasArgName());
        option.setArgName("file");
        Assertions.assertTrue((boolean)option.hasArgName());
    }

    @Test
    void testHasArgs() {
        Option option = new Option("f", null);
        option.setArgs(0);
        Assertions.assertFalse((boolean)option.hasArgs());
        option.setArgs(1);
        Assertions.assertFalse((boolean)option.hasArgs());
        option.setArgs(10);
        Assertions.assertTrue((boolean)option.hasArgs());
        option.setArgs(-2);
        Assertions.assertTrue((boolean)option.hasArgs());
        option.setArgs(-1);
        Assertions.assertFalse((boolean)option.hasArgs());
    }

    @Test
    void testHashCode() {
        Assertions.assertNotEquals((int)Option.builder((String)"test").get().hashCode(), (int)Option.builder((String)"test2").get().hashCode());
        Assertions.assertNotEquals((int)Option.builder((String)"test").get().hashCode(), (int)Option.builder().longOpt("test").get().hashCode());
        Assertions.assertNotEquals((int)Option.builder((String)"test").get().hashCode(), (int)Option.builder((String)"test").longOpt("long test").get().hashCode());
    }

    @Test
    public void testProcessValue() {
        Option option = new Option("D", true, "Define property");
        option.setValueSeparator('=');
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> option.processValue(null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("value"));
    }

    @Test
    void testSerialization() throws IOException, ClassNotFoundException {
        Option option = Option.builder((String)"o").type(TypeHandlerTest.Instantiable.class).get();
        Assertions.assertEquals((Object)Converter.DEFAULT, (Object)option.getConverter());
        Option roundtrip = this.roundTrip(option);
        Assertions.assertEquals((Object)Converter.DEFAULT, (Object)roundtrip.getConverter());
        option.setConverter(Converter.DATE);
        roundtrip = this.roundTrip(option);
        Assertions.assertEquals((Object)Converter.DEFAULT, (Object)roundtrip.getConverter());
        Assertions.assertEquals((Object)Converter.DATE, (Object)option.getConverter());
        roundtrip = this.roundTrip(option);
        Assertions.assertEquals((Object)Converter.DEFAULT, (Object)roundtrip.getConverter());
    }

    @Test
    void testSubclass() {
        DefaultOption option = new DefaultOption("f", "file", "myfile.txt");
        Option clone = (Option)option.clone();
        Assertions.assertEquals((Object)"myfile.txt", (Object)clone.getValue());
        Assertions.assertEquals(DefaultOption.class, clone.getClass());
    }

    @Test
    void testTypeClass() {
        Option option = new Option("f", null);
        Assertions.assertEquals(String.class, (Object)option.getType());
        option.setType(CharSequence.class);
        Assertions.assertEquals(CharSequence.class, (Object)option.getType());
    }

    @Test
    void testTypeObject() {
        Option option = new Option("f", null);
        Assertions.assertEquals(String.class, (Object)option.getType());
        Class<CharSequence> type = CharSequence.class;
        option.setType(type);
        Assertions.assertEquals(CharSequence.class, (Object)option.getType());
    }

    private static final class TestOption
    extends Option {
        private static final long serialVersionUID = 1L;

        TestOption(String opt, boolean hasArg, String description) throws IllegalArgumentException {
            super(opt, hasArg, description);
        }

        public boolean addValue(String value) {
            this.processValue(value);
            return true;
        }
    }

    private static final class DefaultOption
    extends Option {
        private static final long serialVersionUID = 1L;
        private final String defaultValue;

        DefaultOption(String opt, String description, String defaultValue) throws IllegalArgumentException {
            super(opt, true, description);
            this.defaultValue = defaultValue;
        }

        public String getValue() {
            return super.getValue() != null ? super.getValue() : this.defaultValue;
        }
    }
}

