/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.function.IOBooleanSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IOBooleanSupplierTest {
    private AtomicBoolean atomicBoolean;

    IOBooleanSupplierTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.atomicBoolean = new AtomicBoolean();
    }

    private boolean getThrowsIO(IOBooleanSupplier supplier) throws IOException {
        return supplier.getAsBoolean();
    }

    private boolean getThrowsNone(IOBooleanSupplier supplier) {
        return supplier.asBooleanSupplier().getAsBoolean();
    }

    @Test
    void testAsSupplier() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_BOOLEAN_SUPPLIER.asBooleanSupplier().getAsBoolean());
        Assertions.assertEquals((Object)true, (Object)this.getThrowsNone(() -> TestUtils.compareAndSetThrowsIO(this.atomicBoolean, true)));
        Assertions.assertEquals((Object)true, (Object)this.atomicBoolean.get());
        Assertions.assertNotEquals((Object)TestConstants.THROWING_IO_BOOLEAN_SUPPLIER.asBooleanSupplier(), (Object)TestConstants.THROWING_IO_BOOLEAN_SUPPLIER.asBooleanSupplier());
    }

    @Test
    void testGet() throws IOException {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_BOOLEAN_SUPPLIER.getAsBoolean());
        Assertions.assertThrows(IOException.class, () -> {
            throw new IOException();
        });
        Assertions.assertEquals((Object)true, (Object)this.getThrowsIO(() -> TestUtils.compareAndSetThrowsIO(this.atomicBoolean, true)));
        Assertions.assertEquals((Object)true, (Object)this.atomicBoolean.get());
    }
}

