/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.interval;

import org.apache.commons.statistics.distribution.ChiSquaredDistribution;
import org.apache.commons.statistics.distribution.TDistribution;
import org.apache.commons.statistics.interval.ArgumentUtils;
import org.apache.commons.statistics.interval.BaseInterval;
import org.apache.commons.statistics.interval.Interval;

public enum NormalConfidenceInterval {
    MEAN{

        @Override
        Interval create(double mean, double variance, long n, double alpha) {
            double c = TDistribution.of((double)(n - 1L)).inverseSurvivalProbability(alpha * 0.5);
            double distance = c * Math.sqrt(variance / (double)n);
            return new BaseInterval(mean - distance, mean + distance);
        }
    }
    ,
    VARIANCE{

        @Override
        Interval create(double mean, double variance, long n, double alpha) {
            ChiSquaredDistribution d = ChiSquaredDistribution.of((double)(n - 1L));
            double f = variance * ((double)n - 1.0);
            double lower = f / d.inverseSurvivalProbability(alpha * 0.5);
            double upper = f / d.inverseCumulativeProbability(alpha * 0.5);
            return new BaseInterval(lower, upper);
        }
    };


    public Interval fromErrorRate(double mean, double variance, long n, double alpha) {
        if (n <= 1L) {
            throw new IllegalArgumentException("Sample size is not above one: " + n);
        }
        ArgumentUtils.checkErrorRate(alpha);
        return this.create(mean, variance, n, alpha);
    }

    abstract Interval create(double var1, double var3, long var5, double var7);
}

