/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlOutcomeTargetLink;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkTag
extends UIOutput
implements TagEncodingHelperFactory.TagEncodingHolder {
    private static final Logger log = LoggerFactory.getLogger(LinkTag.class);
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.LINK.get());
    public static final String SPAN_ELEM = "span";
    private boolean creatingComponents = false;
    private boolean encodeLinkChildren = false;
    private String disabledTagName;
    private String treeClientId = null;

    public LinkTag() {
        log.trace("component link created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public TagEncodingHelper getEncodingHelper() {
        return this.helper;
    }

    public void setId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            Object page = this.getAttributes().get("page");
            String outcome = StringUtils.toString(page);
            if (StringUtils.isEmpty((String)outcome)) {
                throw new InvalidPropertyException("page", page);
            }
            ParameterMap pm = FacesUtils.getParameterMap(FacesUtils.getContext());
            id = pm.encodeString(outcome);
        }
        super.setId(id);
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.creatingComponents) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        if (this.isLinkDisabled()) {
            ResponseWriter writer = context.getResponseWriter();
            Object linkValue = this.getLinkValue(this.helper.hasColumn());
            this.disabledTagName = this.writeStartElement(writer);
            this.encodeLinkChildren = this.isEncodeLinkChildren(linkValue);
            if (!this.encodeLinkChildren) {
                writer.write(StringUtils.toString((Object)linkValue, (String)""));
                writer.endElement(this.disabledTagName);
            }
        } else {
            HtmlOutcomeTargetLink linkComponent = null;
            if (this.getChildCount() > 0) {
                UIComponent c = (UIComponent)this.getChildren().get(0);
                if (c instanceof HtmlOutcomeTargetLink) {
                    linkComponent = (HtmlOutcomeTargetLink)c;
                    this.helper.restoreComponentId((UIComponent)linkComponent);
                    if (linkComponent.getChildCount() > 0) {
                        int last = linkComponent.getChildCount() - 1;
                        UIComponent lcc = (UIComponent)linkComponent.getChildren().get(last);
                        if (lcc instanceof HtmlGraphicImage) {
                            this.helper.restoreComponentId(lcc);
                        }
                    }
                } else {
                    log.info("INFO: Unexpected child node for {}! Child item type is {}.", (Object)this.getClass().getName(), (Object)c.getClass().getName());
                    UIPanel facetComponent = (UIPanel)this.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
                    if (facetComponent == null) {
                        log.warn("WARN: component's facetComponent has not been set! Using Default (javax.faces.Panel).");
                        log.warn("Problem might be related to Mojarra's state context saving for dynamic components. See com.sun.faces.context.StateContext.java:AddRemoveListener");
                        facetComponent = (UIPanel)context.getApplication().createComponent("javax.faces.Panel");
                        facetComponent.setRendererType("javax.faces.Group");
                        this.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
                    }
                }
            }
            if (linkComponent == null) {
                try {
                    this.creatingComponents = true;
                    linkComponent = this.createOutcomeTargetLink(context);
                    this.getChildren().add(0, linkComponent);
                    this.helper.saveComponentId((UIComponent)linkComponent);
                    String imagePath = this.helper.getTagAttributeString("image");
                    if (StringUtils.isNotEmpty((String)imagePath)) {
                        HtmlGraphicImage img = this.encodeImage(context, linkComponent, imagePath);
                        linkComponent.getChildren().add(img);
                        this.helper.saveComponentId((UIComponent)linkComponent);
                    }
                }
                finally {
                    this.creatingComponents = false;
                }
            }
            this.setLinkProperties(linkComponent);
            this.addOrSetParams(linkComponent);
            this.encodeLinkChildren = this.isEncodeLinkChildren(linkComponent.getChildCount() > 0 ? null : linkComponent.getValue());
            if (this.encodeLinkChildren) {
                linkComponent.encodeBegin(context);
            } else {
                linkComponent.setRendered(true);
                this.encodeLinkComponent(context, linkComponent);
                linkComponent.setRendered(false);
            }
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.encodeLinkChildren) {
            super.encodeChildren(context);
        }
    }

    public void forceEncodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (this.encodeLinkChildren) {
            if (this.isLinkDisabled()) {
                ResponseWriter writer = context.getResponseWriter();
                writer.endElement(StringUtils.coalesce((String)this.disabledTagName, (String)SPAN_ELEM));
            } else {
                HtmlOutcomeTargetLink link = this.getLinkComponent();
                if (link != null && link.isRendered()) {
                    link.encodeEnd(context);
                }
            }
        }
        super.encodeEnd(context);
    }

    protected String getLinkStyleClass() {
        return StringUtils.toString(this.getAttributes().get("styleClass"));
    }

    protected boolean isLinkDisabled() {
        Object v = this.getAttributes().get("disabled");
        if (v == null) {
            return false;
        }
        return ObjectUtils.getBoolean(v);
    }

    protected Object getLinkValue(boolean hasColumn) {
        if (hasColumn) {
            this.helper.prepareData();
            InputControl control = this.helper.getInputControl();
            InputControl.ValueInfo vi = this.helper.getValueInfo(FacesContext.getCurrentInstance());
            Object value = vi.getValue(true);
            return control.formatValue(value, vi, false);
        }
        String text = this.helper.getTagAttributeString("text");
        if (text != null) {
            return this.helper.getTextResolver(FacesContext.getCurrentInstance()).resolveText(text);
        }
        Object value = this.getValue();
        return value;
    }

    protected void setLinkProperties(HtmlOutcomeTargetLink link) {
        String title;
        boolean hasColumn = this.helper.hasColumn();
        Object value = this.getLinkValue(hasColumn);
        link.setValue(value);
        StyleClass cssStyle = this.helper.getSimpleStyleClass(this.getLinkStyleClass());
        link.setStyleClass(cssStyle.build());
        Map attr = this.getAttributes();
        Object page = attr.get("page");
        String outcome = StringUtils.toString(page);
        link.setOutcome(outcome);
        value = attr.get("style");
        if (value != null) {
            link.setStyle(StringUtils.toString((Object)value));
        }
        if ((value = attr.get("tabindex")) != null) {
            link.setTabindex(StringUtils.toString((Object)value));
        }
        if ((value = attr.get("onclick")) != null) {
            link.setOnclick(StringUtils.toString((Object)value));
        }
        if (StringUtils.isNotEmpty((String)(title = this.helper.getTagAttributeString("title")))) {
            link.setTitle(this.helper.getDisplayText(title));
        }
        link.setIncludeViewParams(false);
    }

    protected void addOrSetParams(HtmlOutcomeTargetLink link) {
        this.addOrSetParam(link, "id", StringUtils.toString(this.getAttributes().get("idparam")));
    }

    protected void addOrSetParam(HtmlOutcomeTargetLink link, String paramName, String paramValue) {
        if (StringUtils.isEmpty((String)paramValue)) {
            return;
        }
        if (paramName == null || paramName.length() == 0) {
            throw new InvalidArgumentException("paramName", (Object)paramName);
        }
        List l = link.getChildren();
        for (UIComponent c : l) {
            UIParameter p;
            if (!(c instanceof UIParameter) || !(p = (UIParameter)c).getName().equalsIgnoreCase(paramName)) continue;
            p.setValue((Object)paramValue);
            return;
        }
        UIParameter param = new UIParameter();
        param.setName(paramName);
        param.setValue((Object)paramValue);
        link.getChildren().add(param);
        this.helper.resetComponentId((UIComponent)param);
    }

    protected String writeStartElement(ResponseWriter writer) throws IOException {
        Map map = this.getAttributes();
        String tagName = StringUtils.coalesce((String)StringUtils.toString(map.get("tag")), (String)SPAN_ELEM);
        StyleClass cssClass = this.helper.getTagStyleClass(null);
        Object style = map.get("style");
        Object title = this.helper.getTagAttributeValue("title");
        writer.startElement(tagName, (UIComponent)this);
        this.helper.writeAttribute(writer, "class", cssClass);
        this.helper.writeAttribute(writer, "style", style);
        this.helper.writeAttribute(writer, "title", this.helper.hasColumn() ? this.helper.getValueTooltip(title) : title);
        return tagName;
    }

    protected HtmlOutcomeTargetLink createOutcomeTargetLink(FacesContext context) {
        HtmlOutcomeTargetLink link = InputControlManager.createComponent(context, HtmlOutcomeTargetLink.class);
        return link;
    }

    protected HtmlOutcomeTargetLink getLinkComponent() {
        return this.getChildCount() > 0 ? (HtmlOutcomeTargetLink)this.getChildren().get(0) : null;
    }

    protected boolean isEncodeLinkChildren(Object linkValue) {
        return ObjectUtils.isEmpty((Object)linkValue);
    }

    protected void encodeLinkComponent(FacesContext context, HtmlOutcomeTargetLink linkComponent) throws IOException {
        linkComponent.encodeAll(context);
    }

    protected HtmlGraphicImage encodeImage(FacesContext context, HtmlOutcomeTargetLink parent, String imagePath) {
        HtmlGraphicImage img = InputControlManager.createComponent(context, HtmlGraphicImage.class);
        img.setValue((Object)imagePath);
        return img;
    }
}

