/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class FilterData {
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private OperatorEnum operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<String> values;

    public FilterData operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public FilterData values(List<String> values) {
        this.values = values;
        return this;
    }

    public FilterData addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterData filterData = (FilterData)o;
        return Objects.equals((Object)this.operator, (Object)filterData.operator) && Objects.equals(this.values, filterData.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterData {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatorEnum {
        EQ("EQ"),
        NEQ("NEQ"),
        GTE("GTE"),
        LTE("LTE"),
        GT("GT"),
        LT("LT"),
        LIKE("LIKE"),
        NLIKE("NLIKE"),
        BTW("BTW"),
        NBTW("NBTW"),
        IN("IN"),
        NIN("NIN"),
        NULL("NULL"),
        NNULL("NNULL");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperatorEnum> {
            public void write(JsonWriter jsonWriter, OperatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatorEnum.fromValue(value);
            }
        }
    }
}

