/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.loanaccount.api.LoanChargesApiResource;
import org.springframework.stereotype.Component;

@Component
public class CreateChargeByLoanExternalIdCommandStrategy
implements CommandStrategy {
    private final LoanChargesApiResource loanChargesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        String loanExternalIdPathParameter = (String)pathParameters.get(2);
        String loanExternalId = loanExternalIdPathParameter.contains("?") ? ((String)pathParameters.get(2)).substring(0, ((String)pathParameters.get(2)).indexOf("?")) : (String)pathParameters.get(2);
        Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
        String command = (String)queryParameters.get("command");
        String responseBody = this.loanChargesApiResource.executeLoanCharge(loanExternalId, command, request.getBody());
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public CreateChargeByLoanExternalIdCommandStrategy(LoanChargesApiResource loanChargesApiResource) {
        this.loanChargesApiResource = loanChargesApiResource;
    }
}

