/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class CenterSheetPopulator
extends AbstractWorkbookPopulator {
    private List<CenterData> allCenters;
    private List<OfficeData> offices;
    private Map<String, ArrayList<String>> officeToCenters;
    private Map<Integer, Integer[]> officeNameToBeginEndIndexesOfCenters;
    private Map<String, Long> centerNameToCenterId;
    private static final int OFFICE_NAME_COL = 0;
    private static final int CENTER_NAME_COL = 1;
    private static final int CENTER_ID_COL = 2;

    public CenterSheetPopulator(List<CenterData> centers, List<OfficeData> offices) {
        this.allCenters = centers;
        this.offices = offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet centerSheet = workbook.createSheet("Centers");
        this.setLayout(centerSheet);
        this.setOfficeToCentersMap();
        this.centerNameToCenterIdMap();
        this.populateCentersByOfficeName(centerSheet);
        centerSheet.protectSheet("");
    }

    private void centerNameToCenterIdMap() {
        this.centerNameToCenterId = new HashMap();
        for (CenterData centerData : this.allCenters) {
            this.centerNameToCenterId.put(centerData.getName(), centerData.getId());
        }
    }

    private void populateCentersByOfficeName(Sheet centerSheet) {
        int rowIndex = 1;
        int officeIndex = 0;
        int startIndex = 1;
        this.officeNameToBeginEndIndexesOfCenters = new HashMap();
        Row row = centerSheet.createRow(rowIndex);
        for (OfficeData office : this.offices) {
            startIndex = rowIndex + 1;
            this.writeString(0, row, office.getName());
            if (!this.officeToCenters.containsKey(office.getName().trim().replaceAll("[ )(]", "_"))) continue;
            ArrayList centersList = (ArrayList)this.officeToCenters.get(office.getName().trim().replaceAll("[ )(]", "_"));
            if (!centersList.isEmpty()) {
                for (String centerName : centersList) {
                    this.writeString(1, row, centerName);
                    this.writeLong(2, row, ((Long)this.centerNameToCenterId.get(centerName)).longValue());
                    row = centerSheet.createRow(++rowIndex);
                }
                this.officeNameToBeginEndIndexesOfCenters.put(officeIndex++, new Integer[]{startIndex, rowIndex});
                continue;
            }
            this.officeNameToBeginEndIndexesOfCenters.put(officeIndex++, new Integer[]{startIndex, rowIndex + 1});
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        for (int colIndex = 0; colIndex <= 10; ++colIndex) {
            worksheet.setColumnWidth(colIndex, 6000);
        }
        this.writeString(0, rowHeader, "Office Names");
        this.writeString(1, rowHeader, "Center Names");
        this.writeString(2, rowHeader, "Center ID");
    }

    private void setOfficeToCentersMap() {
        this.officeToCenters = new HashMap();
        for (CenterData center : this.allCenters) {
            this.add(center.getOfficeName().trim().replaceAll("[ )(]", "_"), center.getName().trim());
        }
    }

    private void add(String key, String value) {
        ArrayList<String> values = (ArrayList<String>)this.officeToCenters.get(key);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.officeToCenters.put(key, values);
    }

    public Map<Integer, Integer[]> getOfficeNameToBeginEndIndexesOfCenters() {
        return this.officeNameToBeginEndIndexesOfCenters;
    }
}

