/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailConfigurationData;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailConfigurationNotFoundException;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailConfigurationReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class EmailConfigurationReadPlatformServiceImpl
implements EmailConfigurationReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final EmailConfigurationRowMapper emailConfigurationRowMapper;

    @Autowired
    public EmailConfigurationReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.emailConfigurationRowMapper = new EmailConfigurationRowMapper();
    }

    public Collection<EmailConfigurationData> retrieveAll() {
        String sql = "select " + this.emailConfigurationRowMapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailConfigurationRowMapper);
    }

    public EmailConfigurationData retrieveOne(String name) {
        try {
            String sql = "select " + this.emailConfigurationRowMapper.schema() + " where cnf.name = ?";
            return (EmailConfigurationData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.emailConfigurationRowMapper, new Object[]{name});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmailConfigurationNotFoundException(name, e);
        }
    }

    @Generated
    public EmailConfigurationReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, EmailConfigurationRowMapper emailConfigurationRowMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.emailConfigurationRowMapper = emailConfigurationRowMapper;
    }
}

