/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.getdeliveryreportsfromsmsgateway;

import com.google.gson.Gson;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.campaigns.helper.SmsConfigUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.sms.data.SmsMessageDeliveryReportData;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.infrastructure.sms.service.SmsReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class GetDeliveryReportsFromSmsGatewayTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetDeliveryReportsFromSmsGatewayTasklet.class);
    private final SmsReadPlatformService smsReadPlatformService;
    private final SmsConfigUtils smsConfigUtils;
    private final SmsMessageRepository smsMessageRepository;
    private final RestTemplate restTemplate = new RestTemplate();

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Page smsMessageInternalIds;
        int totalRecords;
        int page = 0;
        Integer limit = 200;
        do {
            smsMessageInternalIds = this.smsReadPlatformService.retrieveAllWaitingForDeliveryReport(limit);
            try {
                HttpEntity entity;
                if (CollectionUtils.isEmpty((Collection)smsMessageInternalIds.getPageItems())) continue;
                Map hostConfig = this.smsConfigUtils.getMessageGateWayRequestURI("sms/report", new Gson().toJson((Object)smsMessageInternalIds.getPageItems()));
                URI uri = (URI)hostConfig.get("uri");
                ResponseEntity responseOne = this.restTemplate.exchange(uri, HttpMethod.POST, entity = (HttpEntity)hostConfig.get("entity"), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Collection smsMessageDeliveryReportDataCollection = (Collection)responseOne.getBody();
                if (!CollectionUtils.isEmpty((Collection)smsMessageDeliveryReportDataCollection)) {
                    for (SmsMessageDeliveryReportData smsMessageDeliveryReportData : smsMessageDeliveryReportDataCollection) {
                        Integer deliveryStatus = smsMessageDeliveryReportData.getDeliveryStatus();
                        if (smsMessageDeliveryReportData.getHasError().booleanValue() || deliveryStatus == 100) continue;
                        SmsMessage smsMessage = this.smsMessageRepository.findById((Object)smsMessageDeliveryReportData.getId()).orElse(null);
                        Integer statusType = switch (deliveryStatus) {
                            case 0 -> SmsMessageStatusType.INVALID.getValue();
                            case 150 -> SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue();
                            case 200 -> SmsMessageStatusType.SENT.getValue();
                            case 300 -> SmsMessageStatusType.DELIVERED.getValue();
                            case 400 -> SmsMessageStatusType.FAILED.getValue();
                            default -> smsMessage.getStatusType();
                        };
                        boolean statusChanged = !statusType.equals(smsMessage.getStatusType());
                        smsMessage.setStatusType(statusType);
                        smsMessage.setExternalId(smsMessageDeliveryReportData.getExternalId());
                        this.smsMessageRepository.save((Object)smsMessage);
                        if (!statusChanged) continue;
                        log.debug("Status of SMS message id: {} successfully changed to {}", (Object)smsMessage.getId(), (Object)statusType);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)smsMessageDeliveryReportDataCollection)) continue;
                log.debug("{} delivery report(s) successfully received from the intermediate gateway - sms", (Object)smsMessageDeliveryReportDataCollection.size());
            }
            catch (Exception e) {
                log.error("Error occurred.", (Throwable)e);
            }
        } while (++page < (totalRecords = smsMessageInternalIds.getTotalFilteredRecords()));
        return RepeatStatus.FINISHED;
    }

    @Generated
    public GetDeliveryReportsFromSmsGatewayTasklet(SmsReadPlatformService smsReadPlatformService, SmsConfigUtils smsConfigUtils, SmsMessageRepository smsMessageRepository) {
        this.smsReadPlatformService = smsReadPlatformService;
        this.smsConfigUtils = smsConfigUtils;
        this.smsMessageRepository = smsMessageRepository;
    }
}

