/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.CodeConstants;
import org.apache.fineract.infrastructure.codes.api.CodeValuesApiResourceSwagger;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/codes/{codeId}/codevalues")
@Component
@Tag(name="Code Values", description="Code and code values: Codes represent a specific category of data, their code values are a specific instance of that category.\n\nCodes are mostly system defined which means the code itself comes out of the box and cannot be modified however its code values can be. e.g. 'Customer Identifier', it defaults to a code value of 'Passport' but could be 'Drivers License, National Id' etc")
public class CodeValuesApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList(CodeConstants.CodevalueJSONinputParams.CODEVALUE_ID.getValue(), CodeConstants.CodevalueJSONinputParams.NAME.getValue(), CodeConstants.CodevalueJSONinputParams.POSITION.getValue(), CodeConstants.CodevalueJSONinputParams.IS_MANDATORY.getValue(), CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue()));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CODEVALUE";
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<CodeValueData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Code Values", description="Returns the list of Code Values for a given Code\n\nExample Requests:\n\ncodes/1/codevalues", parameters={@Parameter(name="codeId", description="co")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A List of code values for a given code", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CodeValuesApiResourceSwagger.GetCodeValuesDataResponse.class)))})})
    public String retrieveAllCodeValues(@Context UriInfo uriInfo, @PathParam(value="codeId") @Parameter(description="codeId") Long codeId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection codeValues = this.readPlatformService.retrieveAllCodeValues(codeId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, codeValues, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{codeValueId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Code description", description="Returns the details of a Code Value\n\nExample Requests:\n\ncodes/1/codevalues/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.GetCodeValuesDataResponse.class))})})
    public String retrieveCodeValue(@Context UriInfo uriInfo, @PathParam(value="codeValueId") @Parameter(description="codeValueId") Long codeValueId, @PathParam(value="codeId") @Parameter(description="codeId") Long codeId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        CodeValueData codeValue = this.readPlatformService.retrieveCodeValue(codeValueId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)codeValue, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Code description", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.PostCodeValuesDataRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.PostCodeValueDataResponse.class))})})
    public String createCodeValue(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCodeValue(codeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{codeValueId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Code description", description="Updates the details of a code description.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.PutCodeValuesDataRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.PutCodeValueDataResponse.class))})})
    public String updateCodeValue(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId, @PathParam(value="codeValueId") @Parameter(description="codeValueId") Long codeValueId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCodeValue(codeId, codeValueId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{codeValueId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Code description", description="Deletes a code description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CodeValuesApiResourceSwagger.DeleteCodeValueDataResponse.class))})})
    public String deleteCodeValue(@PathParam(value="codeId") @Parameter(description="codeId") Long codeId, @PathParam(value="codeValueId") @Parameter(description="codeValueId") Long codeValueId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCodeValue(codeId, codeValueId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public CodeValuesApiResource(PlatformSecurityContext context, CodeValueReadPlatformService readPlatformService, DefaultToApiJsonSerializer<CodeValueData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

