/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.exception;

import org.apache.fineract.infrastructure.core.api.IdTypeResolver;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformResourceNotFoundException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.dao.EmptyResultDataAccessException;

public class JobNotFoundException
extends AbstractPlatformResourceNotFoundException {
    public JobNotFoundException(String identifier) {
        super("error.msg.sheduler.job.id.invalid", "Job with identifier " + identifier + " does not exist", new Object[]{identifier});
    }

    public JobNotFoundException(IdTypeResolver.IdType idType, String jobId) {
        super("error.msg.sheduler.job.id.invalid", String.format("Job with %s: %s cannot be found", idType, jobId), new Object[]{idType, jobId});
    }

    public JobNotFoundException(String identifier, NoSuchJobException e) {
        super("error.msg.sheduler.job.id.invalid", "Job with identifier " + identifier + " does not exist", new Object[]{identifier, e});
    }

    public JobNotFoundException(String identifier, EmptyResultDataAccessException e) {
        super("error.msg.sheduler.job.id.invalid", "Job with identifier " + identifier + " does not exist", new Object[]{identifier, e});
    }
}

