/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import javax.sql.DataSource;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.domain.JdbcSupport;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.migration.TenantDataSourceFactory;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.data.JournalEntryAggregationSummaryData;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class JournalEntryAggregationJobReader
extends JdbcCursorItemReader<JournalEntryAggregationSummaryData> {
    private LocalDate aggregatedOnDateFrom;
    private LocalDate aggregatedOnDateTo;

    public JournalEntryAggregationJobReader(TenantDataSourceFactory tenantDataSourceFactory) {
        FineractPlatformTenant tenant = ThreadLocalContextUtil.getTenant();
        this.setDataSource((DataSource)tenantDataSourceFactory.create(tenant));
        this.setSql(this.buildAggregationQuery());
        this.setRowMapper((arg_0, arg_1) -> this.mapRow(arg_0, arg_1));
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        ExecutionContext ctx = stepExecution.getJobExecution().getExecutionContext();
        this.aggregatedOnDateFrom = (LocalDate)ctx.get("aggregatedOnDateFrom");
        this.aggregatedOnDateTo = (LocalDate)ctx.get("aggregatedOnDateTo");
        this.setPreparedStatementSetter(ps -> {
            ps.setObject(1, this.aggregatedOnDateFrom);
            ps.setObject(2, this.aggregatedOnDateTo);
        });
    }

    private JournalEntryAggregationSummaryData mapRow(ResultSet rs, int rowNum) throws SQLException {
        return JournalEntryAggregationSummaryData.builder().glAccountId(Long.valueOf(rs.getLong("glAccountId"))).productId(Long.valueOf(rs.getLong("productId"))).office(Long.valueOf(rs.getLong("officeId"))).entityTypeEnum(Long.valueOf(rs.getLong("entityTypeEnum"))).currencyCode(rs.getString("currencyCode")).submittedOnDate(ThreadLocalContextUtil.getBusinessDate()).aggregatedOnDate(JdbcSupport.getLocalDate((ResultSet)rs, (String)"aggregatedOnDate")).externalOwnerId(JdbcSupport.getLong((ResultSet)rs, (String)"externalOwner")).debitAmount(rs.getBigDecimal("debitAmount")).creditAmount(rs.getBigDecimal("creditAmount")).manualEntry(Boolean.valueOf(false)).build();
    }

    private String buildAggregationQuery() {
        return "SELECT\n    COALESCE(\n        loan_product.id,\n        savings_product.id,\n        prov_product.id,\n        share_product.id\n    ) AS productId,\n    acc_gl_account.id AS glAccountId,\n    acc_gl_journal_entry.entity_type_enum AS entityTypeEnum,\n    acc_gl_journal_entry.office_id AS officeId,\n    aw.owner_id AS externalOwner,\n    SUM(CASE WHEN acc_gl_journal_entry.type_enum = 2 THEN amount ELSE 0 END) AS debitAmount,\n    SUM(CASE WHEN acc_gl_journal_entry.type_enum = 1 THEN amount ELSE 0 END) AS creditAmount,\n    acc_gl_journal_entry.submitted_on_date AS aggregatedOnDate,\n    acc_gl_journal_entry.currency_code AS currencyCode\nFROM acc_gl_account\nJOIN acc_gl_journal_entry\n    ON acc_gl_account.id = acc_gl_journal_entry.account_id\n\n-- entity_type_enum = 1 \u2192 LOAN\nLEFT JOIN m_loan loan\n    ON loan.id = acc_gl_journal_entry.entity_id\n    AND acc_gl_journal_entry.entity_type_enum = 1\nLEFT JOIN m_product_loan loan_product\n    ON loan_product.id = loan.product_id\n    AND acc_gl_journal_entry.entity_type_enum = 1\n\n-- entity_type_enum = 2 \u2192 SAVING\nLEFT JOIN m_savings_account savings\n    ON savings.id = acc_gl_journal_entry.entity_id\n    AND acc_gl_journal_entry.entity_type_enum = 2\nLEFT JOIN m_savings_product savings_product\n    ON savings_product.id = savings.product_id\n    AND acc_gl_journal_entry.entity_type_enum = 2\n\n-- entity_type_enum = 3 \u2192 PROVISIONING\nLEFT JOIN m_provisioning_history prov\n    ON prov.id = acc_gl_journal_entry.entity_id\n    AND acc_gl_journal_entry.entity_type_enum = 3\nLEFT JOIN m_loanproduct_provisioning_entry prov_entry\n    ON prov_entry.history_id = prov.id\n    AND acc_gl_journal_entry.entity_type_enum = 3\nLEFT JOIN m_product_loan prov_product\n    ON prov_product.id = prov_entry.product_id\n    AND acc_gl_journal_entry.entity_type_enum = 3\n\n-- entity_type_enum = 4 \u2192 SHARED\nLEFT JOIN m_share_account share\n    ON share.id = acc_gl_journal_entry.entity_id\n    AND acc_gl_journal_entry.entity_type_enum = 4\nLEFT JOIN m_share_product share_product\n    ON share_product.id = share.product_id\n    AND acc_gl_journal_entry.entity_type_enum = 4\n\n-- external owner\nLEFT JOIN m_external_asset_owner_journal_entry_mapping aw\n    ON aw.journal_entry_id = acc_gl_journal_entry.id\n\nWHERE acc_gl_journal_entry.submitted_on_date > ?\n  AND acc_gl_journal_entry.submitted_on_date <= ?\n\nGROUP BY\n    productId,\n    glAccountId,\n    externalOwner,\n    aggregatedOnDate,\n    currencyCode,\n    entityTypeEnum,\n    officeId\n";
    }
}

