/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;

public class InteropIdentifierRequestData {
    static final String[] PARAMS = new String[]{"accountId"};
    @NotEmpty
    private final InteropIdentifierType idType;
    @NotEmpty
    private final String idValue;
    private final String subIdOrType;
    @NotEmpty
    private final String accountId;

    public InteropIdentifierRequestData(@NotNull InteropIdentifierType idType, @NotNull String idValue, String subIdOrType, String accountId) {
        this.idType = idType;
        this.idValue = idValue;
        this.subIdOrType = subIdOrType;
        this.accountId = accountId;
    }

    public InteropIdentifierType getIdType() {
        return this.idType;
    }

    public String getIdValue() {
        return this.idValue;
    }

    public String getSubIdOrType() {
        return this.subIdOrType;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static InteropIdentifierRequestData validateAndParse(DataValidatorBuilder dataValidator, @NotNull InteropIdentifierType idType, @NotNull String idValue, String subIdOrType, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, Arrays.asList(PARAMS));
        String accountId = jsonHelper.extractStringNamed("accountId", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("accountId").value((Object)accountId).notBlank();
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new InteropIdentifierRequestData(idType, idValue, subIdOrType, accountId);
    }
}

