/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.FieldConfigurationData;
import org.apache.fineract.portfolio.address.service.FieldConfigurationReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/fieldconfiguration/{entity}")
@Component
@Tag(name="Entity Field Configuration", description="Entity Field configuration API is a generic and extensible \nwherein various entities and subentities can be related.\nAlso it gives the user an ability to enable/disable fields,\nadd regular expression for validation")
public class EntityFieldConfigurationApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "Address";
    private final PlatformSecurityContext context;
    private final FieldConfigurationReadPlatformService readPlatformServicefld;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the Entity Field Configuration", description="It retrieves all the Entity Field Configuration")
    public List<FieldConfigurationData> getAddresses(@PathParam(value="entity") @Parameter(description="entity") String entityname) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformServicefld.retrieveFieldConfiguration(entityname);
    }

    @Generated
    public EntityFieldConfigurationApiResource(PlatformSecurityContext context, FieldConfigurationReadPlatformService readPlatformServicefld) {
        this.context = context;
        this.readPlatformServicefld = readPlatformServicefld;
    }
}

