/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.exception;

import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformDomainRuleException;
import org.springframework.dao.EmptyResultDataAccessException;

public class ClientTransactionNotFoundException
extends AbstractPlatformDomainRuleException {
    public ClientTransactionNotFoundException(Long clientId, Long transactionId) {
        super("error.msg.client.transaction.not.found.exception", "The Transaction with id `" + transactionId + "` does not exist for a Client with id `" + clientId, new Object[]{transactionId, clientId});
    }

    public ClientTransactionNotFoundException(Long clientId, ExternalId transactionId) {
        super("error.msg.client.transaction.not.found.exception", "The Transaction with id `" + transactionId.getValue() + "` does not exist for a Client with id `" + clientId, new Object[]{transactionId.getValue(), clientId});
    }

    public ClientTransactionNotFoundException(Long clientId, Long transactionId, EmptyResultDataAccessException e) {
        super("error.msg.client.transaction.not.found.exception", "The Transaction with id `" + transactionId + "` does not exist for a Client with id `" + clientId, new Object[]{transactionId, clientId, e});
    }
}

