/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.JdbcSupport;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.data.GroupTimelineData;
import org.springframework.jdbc.core.RowMapper;

public final class AllGroupTypesDataMapper
implements RowMapper<GroupGeneralData> {
    private final String schemaSql;

    public AllGroupTypesDataMapper() {
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("g.id as id, g.account_no as accountNumber, g.external_id as externalId, g.display_name as name, ");
        sqlBuilder.append("g.office_id as officeId, o.name as officeName, ");
        sqlBuilder.append("g.parent_id as centerId, pg.display_name as centerName, ");
        sqlBuilder.append("g.staff_id as staffId, s.display_name as staffName, ");
        sqlBuilder.append("g.status_enum as statusEnum, g.activation_date as activationDate, ");
        sqlBuilder.append("g.closedon_date as closedOnDate, ");
        sqlBuilder.append("g.submittedon_date as submittedOnDate, ");
        sqlBuilder.append("sbu.username as submittedByUsername, ");
        sqlBuilder.append("sbu.firstname as submittedByFirstname, ");
        sqlBuilder.append("sbu.lastname as submittedByLastname, ");
        sqlBuilder.append("clu.username as closedByUsername, ");
        sqlBuilder.append("clu.firstname as closedByFirstname, ");
        sqlBuilder.append("clu.lastname as closedByLastname, ");
        sqlBuilder.append("acu.username as activatedByUsername, ");
        sqlBuilder.append("acu.firstname as activatedByFirstname, ");
        sqlBuilder.append("acu.lastname as activatedByLastname, ");
        sqlBuilder.append("g.hierarchy as hierarchy, ");
        sqlBuilder.append("g.level_id as groupLevel ");
        sqlBuilder.append("from m_group g ");
        sqlBuilder.append("join m_office o on o.id = g.office_id ");
        sqlBuilder.append("left join m_staff s on s.id = g.staff_id ");
        sqlBuilder.append("left join m_group pg on pg.id = g.parent_id ");
        sqlBuilder.append("left join m_appuser sbu on sbu.id = g.submittedon_userid ");
        sqlBuilder.append("left join m_appuser acu on acu.id = g.activatedon_userid ");
        sqlBuilder.append("left join m_appuser clu on clu.id = g.closedon_userid ");
        this.schemaSql = sqlBuilder.toString();
    }

    public String schema() {
        return this.schemaSql;
    }

    public GroupGeneralData mapRow(ResultSet rs, int rowNum) throws SQLException {
        Long id = rs.getLong("id");
        String accountNo = rs.getString("accountNumber");
        String name = rs.getString("name");
        String externalId = rs.getString("externalId");
        Integer statusEnum = JdbcSupport.getInteger((ResultSet)rs, (String)"statusEnum");
        EnumOptionData status = ClientEnumerations.status((Integer)statusEnum);
        LocalDate activationDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"activationDate");
        Long officeId = JdbcSupport.getLong((ResultSet)rs, (String)"officeId");
        String officeName = rs.getString("officeName");
        Long centerId = JdbcSupport.getLong((ResultSet)rs, (String)"centerId");
        String centerName = rs.getString("centerName");
        Long staffId = JdbcSupport.getLong((ResultSet)rs, (String)"staffId");
        String staffName = rs.getString("staffName");
        String hierarchy = rs.getString("hierarchy");
        String groupLevel = rs.getString("groupLevel");
        LocalDate closedOnDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"closedOnDate");
        String closedByUsername = rs.getString("closedByUsername");
        String closedByFirstname = rs.getString("closedByFirstname");
        String closedByLastname = rs.getString("closedByLastname");
        LocalDate submittedOnDate = JdbcSupport.getLocalDate((ResultSet)rs, (String)"submittedOnDate");
        String submittedByUsername = rs.getString("submittedByUsername");
        String submittedByFirstname = rs.getString("submittedByFirstname");
        String submittedByLastname = rs.getString("submittedByLastname");
        String activatedByUsername = rs.getString("activatedByUsername");
        String activatedByFirstname = rs.getString("activatedByFirstname");
        String activatedByLastname = rs.getString("activatedByLastname");
        GroupTimelineData timeline = new GroupTimelineData(submittedOnDate, submittedByUsername, submittedByFirstname, submittedByLastname, activationDate, activatedByUsername, activatedByFirstname, activatedByLastname, closedOnDate, closedByUsername, closedByFirstname, closedByLastname);
        return GroupGeneralData.instance((Long)id, (String)accountNo, (String)name, (String)externalId, (EnumOptionData)status, (LocalDate)activationDate, (Long)officeId, (String)officeName, (Long)centerId, (String)centerName, (Long)staffId, (String)staffName, (String)hierarchy, (String)groupLevel, (GroupTimelineData)timeline);
    }
}

