/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.service;

import java.util.LinkedHashMap;
import java.util.Locale;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartSlabDataValidator;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChartRepositoryWrapper;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChartSlab;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChartSlabRepository;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartAssembler;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartSlabAssembler;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartSlabWritePlatformService;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.springframework.transaction.annotation.Transactional;

public class InterestRateChartSlabWritePlatformServiceJpaRepositoryImpl
implements InterestRateChartSlabWritePlatformService {
    private final PlatformSecurityContext context;
    private final InterestRateChartSlabDataValidator interestRateChartSlabDataValidator;
    private final InterestRateChartAssembler interestRateChartAssembler;
    private final InterestRateChartSlabAssembler interestRateChartSlabAssembler;
    private final InterestRateChartRepositoryWrapper interestRateChartRepository;
    private final InterestRateChartSlabRepository chartSlabRepository;
    private final SavingsProductRepository savingsProductRepository;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        this.interestRateChartSlabDataValidator.validateCreate(command.json());
        InterestRateChartSlab interestRateChartSlab = this.interestRateChartSlabAssembler.assembleFrom(command);
        this.chartSlabRepository.saveAndFlush((Object)interestRateChartSlab);
        Long interestRateChartId = (Long)interestRateChartSlab.getId();
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(interestRateChartId).build();
    }

    @Transactional
    public CommandProcessingResult update(Long chartSlabId, Long interestRateChartId, JsonCommand command) {
        this.interestRateChartSlabDataValidator.validateUpdate(command.json());
        LinkedHashMap changes = new LinkedHashMap(20);
        InterestRateChartSlab updateChartSlabs = this.interestRateChartSlabAssembler.assembleFrom(chartSlabId, interestRateChartId);
        Locale locale = command.extractLocale();
        updateChartSlabs.update(command, changes, locale);
        this.chartSlabRepository.saveAndFlush((Object)updateChartSlabs);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(interestRateChartId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult deleteChartSlab(Long chartSlabId, Long interestRateChartId) {
        InterestRateChartSlab deleteChartSlabs = this.interestRateChartSlabAssembler.assembleFrom(chartSlabId, interestRateChartId);
        this.chartSlabRepository.delete((Object)deleteChartSlabs);
        return new CommandProcessingResultBuilder().withEntityId(chartSlabId).build();
    }

    @Generated
    public InterestRateChartSlabWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, InterestRateChartSlabDataValidator interestRateChartSlabDataValidator, InterestRateChartAssembler interestRateChartAssembler, InterestRateChartSlabAssembler interestRateChartSlabAssembler, InterestRateChartRepositoryWrapper interestRateChartRepository, InterestRateChartSlabRepository chartSlabRepository, SavingsProductRepository savingsProductRepository) {
        this.context = context;
        this.interestRateChartSlabDataValidator = interestRateChartSlabDataValidator;
        this.interestRateChartAssembler = interestRateChartAssembler;
        this.interestRateChartSlabAssembler = interestRateChartSlabAssembler;
        this.interestRateChartRepository = interestRateChartRepository;
        this.chartSlabRepository = chartSlabRepository;
        this.savingsProductRepository = savingsProductRepository;
    }
}

