/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.updatesavingsdormantaccounts;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class UpdateSavingsDormantAccountsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateSavingsDormantAccountsTasklet.class);
    private final SavingsAccountReadPlatformService savingAccountReadPlatformService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        List savingsPendingEscheat;
        List savingsPendingDormant;
        LocalDate tenantLocalDate = DateUtils.getBusinessLocalDate();
        List savingsPendingInactive = this.savingAccountReadPlatformService.retrieveSavingsIdsPendingInactive(tenantLocalDate);
        if (null != savingsPendingInactive && savingsPendingInactive.size() > 0) {
            for (Object savingsId : savingsPendingInactive) {
                this.savingsAccountWritePlatformService.setSubStatusInactive((Long)savingsId);
            }
        }
        if (null != (savingsPendingDormant = this.savingAccountReadPlatformService.retrieveSavingsIdsPendingDormant(tenantLocalDate)) && savingsPendingDormant.size() > 0) {
            for (Long savingsId : savingsPendingDormant) {
                this.savingsAccountWritePlatformService.setSubStatusDormant(savingsId);
            }
        }
        if (null != (savingsPendingEscheat = this.savingAccountReadPlatformService.retrieveSavingsIdsPendingEscheat(tenantLocalDate)) && savingsPendingEscheat.size() > 0) {
            for (Long savingsId : savingsPendingEscheat) {
                this.savingsAccountWritePlatformService.escheat(savingsId);
            }
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public UpdateSavingsDormantAccountsTasklet(SavingsAccountReadPlatformService savingAccountReadPlatformService, SavingsAccountWritePlatformService savingsAccountWritePlatformService) {
        this.savingAccountReadPlatformService = savingAccountReadPlatformService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
    }
}

