/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import jakarta.persistence.PersistenceException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.SavingsProductDataValidator;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.SavingsProductAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsProductWritePlatformService;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class SavingsProductWritePlatformServiceJpaRepositoryImpl
implements SavingsProductWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SavingsProductWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final SavingsProductRepository savingProductRepository;
    private final SavingsProductDataValidator fromApiJsonDataValidator;
    private final SavingsProductAssembler savingsProductAssembler;
    private final ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService;
    private final FineractEntityAccessUtil fineractEntityAccessUtil;

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dae) {
        Object[] msgArgs;
        Throwable checkEx;
        Object msgCode = "error.msg.savingsproduct";
        Object msg = "Unknown data integrity issue with savings product.";
        String param = null;
        Throwable throwable = checkEx = realCause == null ? dae : realCause;
        if (checkEx.getMessage().contains("sp_unq_name")) {
            String name = command.stringValueOfParameterNamed("name");
            msgCode = (String)msgCode + ".duplicate.name";
            msg = "Savings product with name `" + name + "` already exists";
            param = "name";
            msgArgs = new Object[]{name, dae};
        } else if (checkEx.getMessage().contains("sp_unq_short_name")) {
            String shortName = command.stringValueOfParameterNamed("shortName");
            msgCode = (String)msgCode + ".duplicate.short.name";
            msg = "Savings product with short name `" + shortName + "` already exists";
            param = "shortName";
            msgArgs = new Object[]{shortName, dae};
        } else {
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dae};
        }
        log.error("Error occured.", (Throwable)dae);
        throw ErrorHandler.getMappable((Throwable)dae, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        try {
            this.fromApiJsonDataValidator.validateForCreate(command.json());
            SavingsProduct product = this.savingsProductAssembler.assemble(command);
            this.savingProductRepository.saveAndFlush((Object)product);
            this.accountMappingWritePlatformService.createSavingProductToGLAccountMapping((Long)product.getId(), command, DepositAccountType.SAVINGS_DEPOSIT);
            this.fineractEntityAccessUtil.checkConfigurationAndAddProductResrictionsForUserOffice(FineractEntityAccessType.OFFICE_ACCESS_TO_SAVINGS_PRODUCTS, (Long)product.getId());
            return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).build();
        }
        catch (DataAccessException e) {
            this.handleDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues(command, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult update(Long productId, JsonCommand command) {
        try {
            Set savingsProductCharges;
            boolean updated;
            this.context.authenticatedUser();
            SavingsProduct product = (SavingsProduct)this.savingProductRepository.findById((Object)productId).orElseThrow(() -> new SavingsProductNotFoundException(productId));
            this.fromApiJsonDataValidator.validateForUpdate(command.json(), product);
            Map changes = product.update(command);
            if (changes.containsKey("charges") && !(updated = product.update(savingsProductCharges = this.savingsProductAssembler.assembleListOfSavingsProductCharges(command, product.currency().getCode())))) {
                changes.remove("charges");
            }
            if (changes.containsKey("taxGroupId")) {
                TaxGroup taxGroup = this.savingsProductAssembler.assembleTaxGroup(command);
                product.setTaxGroup(taxGroup);
                if (product.withHoldTax() && product.getTaxGroup() == null) {
                    ArrayList dataValidationErrors = new ArrayList();
                    DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsproduct");
                    Object taxGroupId = null;
                    baseDataValidator.reset().parameter("taxGroupId").value(taxGroupId).notBlank();
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            boolean accountingTypeChanged = changes.containsKey("accountingRule");
            Map accountingMappingChanges = this.accountMappingWritePlatformService.updateSavingsProductToGLAccountMapping((Long)product.getId(), command, accountingTypeChanged, product.getAccountingType().intValue(), DepositAccountType.SAVINGS_DEPOSIT);
            changes.putAll(accountingMappingChanges);
            if (!changes.isEmpty()) {
                this.savingProductRepository.saveAndFlush((Object)product);
            }
            return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).with(changes).build();
        }
        catch (DataAccessException e) {
            this.handleDataIntegrityIssues(command, e.getMostSpecificCause(), (Exception)((Object)e));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues(command, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long productId) {
        this.context.authenticatedUser();
        SavingsProduct product = (SavingsProduct)this.savingProductRepository.findById((Object)productId).orElseThrow(() -> new SavingsProductNotFoundException(productId));
        this.savingProductRepository.delete((Object)product);
        return new CommandProcessingResultBuilder().withEntityId((Long)product.getId()).build();
    }

    @Generated
    public SavingsProductWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, SavingsProductRepository savingProductRepository, SavingsProductDataValidator fromApiJsonDataValidator, SavingsProductAssembler savingsProductAssembler, ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService, FineractEntityAccessUtil fineractEntityAccessUtil) {
        this.context = context;
        this.savingProductRepository = savingProductRepository;
        this.fromApiJsonDataValidator = fromApiJsonDataValidator;
        this.savingsProductAssembler = savingsProductAssembler;
        this.accountMappingWritePlatformService = accountMappingWritePlatformService;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
    }
}

