/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.service;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.self.account.data.SelfBeneficiariesTPTDataValidator;
import org.apache.fineract.portfolio.self.account.domain.SelfBeneficiariesTPT;
import org.apache.fineract.portfolio.self.account.domain.SelfBeneficiariesTPTRepository;
import org.apache.fineract.portfolio.self.account.exception.InvalidAccountInformationException;
import org.apache.fineract.portfolio.self.account.exception.InvalidBeneficiaryException;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class SelfBeneficiariesTPTWritePlatformServiceImpl
implements SelfBeneficiariesTPTWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfBeneficiariesTPTWritePlatformServiceImpl.class);
    private final PlatformSecurityContext context;
    private final SelfBeneficiariesTPTRepository repository;
    private final SelfBeneficiariesTPTDataValidator validator;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final SavingsAccountRepositoryWrapper savingRepositoryWrapper;

    @Transactional
    public CommandProcessingResult add(JsonCommand command) {
        HashMap params = this.validator.validateForCreate(command.json());
        String name = (String)params.get("name");
        Integer accountType = (Integer)params.get("accountType");
        String accountNumber = (String)params.get("accountNumber");
        String officeName = (String)params.get("officeName");
        Long transferLimit = (Long)params.get("transferLimit");
        Long accountId = null;
        Long clientId = null;
        Long officeId = null;
        boolean validAccountDetails = true;
        if (accountType.equals(PortfolioAccountType.LOAN.getValue())) {
            Loan loan = this.loanRepositoryWrapper.findNonClosedLoanByAccountNumber(accountNumber);
            if (loan != null && loan.getClientId() != null && loan.getOffice().getName().equals(officeName)) {
                accountId = (Long)loan.getId();
                officeId = loan.getOfficeId();
                clientId = loan.getClientId();
            } else {
                validAccountDetails = false;
            }
        } else {
            SavingsAccount savings = this.savingRepositoryWrapper.findNonClosedAccountByAccountNumber(accountNumber);
            if (savings != null && savings.getClient() != null && savings.getClient().getOffice().getName().equals(officeName)) {
                accountId = (Long)savings.getId();
                clientId = (Long)savings.getClient().getId();
                officeId = (Long)savings.getClient().getOffice().getId();
            } else {
                validAccountDetails = false;
            }
        }
        if (validAccountDetails) {
            try {
                AppUser user = this.context.authenticatedUser();
                SelfBeneficiariesTPT beneficiary = new SelfBeneficiariesTPT((Long)user.getId(), name, officeId, clientId, accountId, accountType, transferLimit);
                this.repository.saveAndFlush((Object)beneficiary);
                return new CommandProcessingResultBuilder().withEntityId((Long)beneficiary.getId()).build();
            }
            catch (DataAccessException dae) {
                this.handleDataIntegrityIssues(command, dae);
            }
        }
        throw new InvalidAccountInformationException(officeName, accountNumber, PortfolioAccountType.fromInt((Integer)accountType).getCode());
    }

    @Transactional
    public CommandProcessingResult update(JsonCommand command) {
        Long transferLimit;
        String name;
        Map changes;
        HashMap params = this.validator.validateForUpdate(command.json());
        AppUser user = this.context.authenticatedUser();
        Long beneficiaryId = command.entityId();
        SelfBeneficiariesTPT beneficiary = this.repository.findById((Object)beneficiaryId).orElse(null);
        if (beneficiary != null && beneficiary.getAppUserId().equals(user.getId()) && !(changes = beneficiary.update(name = (String)params.get("name"), transferLimit = (Long)params.get("transferLimit"))).isEmpty()) {
            try {
                this.repository.saveAndFlush((Object)beneficiary);
                return new CommandProcessingResultBuilder().withEntityId((Long)beneficiary.getId()).with(changes).build();
            }
            catch (DataAccessException dae) {
                this.handleDataIntegrityIssues(command, dae);
            }
        }
        throw new InvalidBeneficiaryException(beneficiaryId);
    }

    @Transactional
    public CommandProcessingResult delete(JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        Long beneficiaryId = command.entityId();
        SelfBeneficiariesTPT beneficiary = this.repository.findById((Object)beneficiaryId).orElse(null);
        if (beneficiary != null && beneficiary.getAppUserId().equals(user.getId())) {
            beneficiary.setActive(false);
            this.repository.save((Object)beneficiary);
            return new CommandProcessingResultBuilder().withEntityId((Long)beneficiary.getId()).build();
        }
        throw new InvalidBeneficiaryException(beneficiaryId);
    }

    private void handleDataIntegrityIssues(JsonCommand command, DataAccessException dae) {
        Throwable realCause = dae.getMostSpecificCause();
        if (realCause.getMessage().contains("name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.beneficiary.duplicate.name", "Beneficiary with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dae);
        throw ErrorHandler.getMappable((Throwable)dae, (String)"error.msg.beneficiary.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public SelfBeneficiariesTPTWritePlatformServiceImpl(PlatformSecurityContext context, SelfBeneficiariesTPTRepository repository, SelfBeneficiariesTPTDataValidator validator, LoanRepositoryWrapper loanRepositoryWrapper, SavingsAccountRepositoryWrapper savingRepositoryWrapper) {
        this.context = context;
        this.repository = repository;
        this.validator = validator;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.savingRepositoryWrapper = savingRepositoryWrapper;
    }
}

