/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.spm.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.spm.api.SpmApiResource;
import org.apache.fineract.spm.data.SurveyData;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/v1/self/surveys")
@Component
@Tag(name="Self Spm", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfSpmApiResource {
    private final PlatformSecurityContext securityContext;
    private final SpmApiResource spmApiResource;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public List<SurveyData> fetchAllSurveys() {
        this.securityContext.authenticatedUser();
        Boolean isActive = true;
        return this.spmApiResource.fetchAllSurveys(isActive);
    }

    @Generated
    public SelfSpmApiResource(PlatformSecurityContext securityContext, SpmApiResource spmApiResource) {
        this.securityContext = securityContext;
        this.spmApiResource = spmApiResource;
    }
}

