/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.utils;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public abstract class GroupAggHelper {
    private final RecordCounter recordCounter;
    private final boolean generateUpdateBefore;
    private final StateTtlConfig ttlConfig;
    private final AggsHandleFunction function;
    private final RecordEqualiser equaliser;
    private final JoinedRowData resultRow;

    public GroupAggHelper(RecordCounter recordCounter, boolean generateUpdateBefore, StateTtlConfig ttlConfig, AggsHandleFunction function, RecordEqualiser equaliser) {
        this.recordCounter = recordCounter;
        this.generateUpdateBefore = generateUpdateBefore;
        this.ttlConfig = ttlConfig;
        this.function = function;
        this.equaliser = equaliser;
        this.resultRow = new JoinedRowData();
    }

    public void processElement(RowData input, RowData currentKey, RowData accumulators, Collector<RowData> out) throws Exception {
        boolean firstRow;
        if (null == accumulators) {
            if (RowDataUtil.isRetractMsg(input)) {
                return;
            }
            firstRow = true;
            accumulators = this.function.createAccumulators();
        } else {
            firstRow = false;
        }
        this.function.setAccumulators(accumulators);
        RowData prevAggValue = this.function.getValue();
        if (RowDataUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        RowData newAggValue = this.function.getValue();
        accumulators = this.function.getAccumulators();
        if (!this.recordCounter.recordCountIsZero(accumulators)) {
            this.updateAccumulatorsState(accumulators);
            if (!firstRow) {
                if (!this.ttlConfig.isEnabled() && this.equaliser.equals(prevAggValue, newAggValue)) {
                    return;
                }
                if (this.generateUpdateBefore) {
                    this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)this.resultRow);
                }
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.UPDATE_AFTER);
            } else {
                this.resultRow.replace(currentKey, newAggValue).setRowKind(RowKind.INSERT);
            }
            out.collect((Object)this.resultRow);
        } else {
            if (!firstRow) {
                this.resultRow.replace(currentKey, prevAggValue).setRowKind(RowKind.DELETE);
                out.collect((Object)this.resultRow);
            }
            this.clearAccumulatorsState();
            this.function.cleanup();
        }
    }

    protected abstract void updateAccumulatorsState(RowData var1) throws Exception;

    protected abstract void clearAccumulatorsState() throws Exception;
}

