/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class DynamicPartitionWriter<T>
implements PartitionWriter<T> {
    private final PartitionWriter.Context<T> context;
    private final PartitionTempFileManager manager;
    private final PartitionComputer<T> computer;
    private final Map<String, OutputFormat<T>> formats;
    private final PartitionWriter.PartitionWriterListener writerListener;

    public DynamicPartitionWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer) {
        this(context, manager, computer, new PartitionWriter.DefaultPartitionWriterListener());
    }

    public DynamicPartitionWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer, PartitionWriter.PartitionWriterListener writerListener) {
        this.context = context;
        this.manager = manager;
        this.computer = computer;
        this.formats = new HashMap<String, OutputFormat<T>>();
        this.writerListener = writerListener;
    }

    @Override
    public void write(T in) throws Exception {
        String partition = PartitionPathUtils.generatePartitionPath(this.computer.generatePartValues(in));
        OutputFormat<T> format = this.formats.get(partition);
        if (format == null) {
            Path path = this.manager.createPartitionDir(partition);
            format = this.context.createNewOutputFormat(path);
            this.formats.put(partition, format);
            this.writerListener.onFileOpened(partition, path);
        }
        format.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        for (OutputFormat<T> format : this.formats.values()) {
            format.close();
        }
        this.formats.clear();
    }
}

