/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.configuration;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.cep.configuration.CEPCacheOptions;
import org.apache.flink.configuration.ReadableConfig;

public final class SharedBufferCacheConfig
implements Serializable {
    private final int eventsBufferCacheSlots;
    private final int entryCacheSlots;
    private final Duration cacheStatisticsInterval;

    public int getEventsBufferCacheSlots() {
        return this.eventsBufferCacheSlots;
    }

    public int getEntryCacheSlots() {
        return this.entryCacheSlots;
    }

    public Duration getCacheStatisticsInterval() {
        return this.cacheStatisticsInterval;
    }

    public SharedBufferCacheConfig() {
        this.cacheStatisticsInterval = (Duration)CEPCacheOptions.CEP_CACHE_STATISTICS_INTERVAL.defaultValue();
        this.entryCacheSlots = (Integer)CEPCacheOptions.CEP_SHARED_BUFFER_ENTRY_CACHE_SLOTS.defaultValue();
        this.eventsBufferCacheSlots = (Integer)CEPCacheOptions.CEP_SHARED_BUFFER_EVENT_CACHE_SLOTS.defaultValue();
    }

    public SharedBufferCacheConfig(int eventsBufferCacheSlots, int entryCacheSlots, Duration cacheStatisticsInterval) {
        this.cacheStatisticsInterval = cacheStatisticsInterval;
        this.entryCacheSlots = entryCacheSlots;
        this.eventsBufferCacheSlots = eventsBufferCacheSlots;
    }

    public static SharedBufferCacheConfig of(ReadableConfig readableConfig) {
        int eventsBufferCacheSlots = (Integer)readableConfig.get(CEPCacheOptions.CEP_SHARED_BUFFER_EVENT_CACHE_SLOTS);
        int entryCacheSlots = (Integer)readableConfig.get(CEPCacheOptions.CEP_SHARED_BUFFER_ENTRY_CACHE_SLOTS);
        Duration cacheStatisticsInterval = (Duration)readableConfig.get(CEPCacheOptions.CEP_CACHE_STATISTICS_INTERVAL);
        return new SharedBufferCacheConfig(eventsBufferCacheSlots, entryCacheSlots, cacheStatisticsInterval);
    }
}

