/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlJsonQueryFunction;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.plan.type.FlinkReturnTypes;

class SqlJsonQueryFunctionWrapper
extends SqlJsonQueryFunction {
    private final SqlReturnTypeInference returnTypeInference = ReturnTypes.cascade(SqlJsonQueryFunctionWrapper::explicitTypeSpec, SqlTypeTransforms.FORCE_NULLABLE).orElse(FlinkReturnTypes.VARCHAR_FORCE_NULLABLE);

    SqlJsonQueryFunctionWrapper() {
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType returnType = this.returnTypeInference.inferReturnType(opBinding);
        if (returnType == null) {
            throw new IllegalArgumentException("Cannot infer return type for " + String.valueOf(opBinding.getOperator()) + "; operand types: " + String.valueOf(opBinding.collectOperandTypes()));
        }
        return returnType;
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return this.returnTypeInference;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType type;
        if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
            return false;
        }
        if (callBinding.getOperandCount() >= 6 && SqlTypeUtil.isArray(type = SqlTypeUtil.deriveType(callBinding, callBinding.operand(5)))) {
            return SqlJsonQueryFunctionWrapper.checkOperandsForArrayReturnType(throwOnFailure, type, callBinding);
        }
        return true;
    }

    private static boolean checkOperandsForArrayReturnType(boolean throwOnFailure, RelDataType type, SqlCallBinding callBinding) {
        if (!SqlTypeUtil.isCharacter(type.getComponentType())) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Unsupported array element type '%s' for RETURNING ARRAY in JSON_QUERY().", type.getComponentType()));
            }
            return false;
        }
        if (SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT.equals(SqlJsonQueryFunctionWrapper.getEnumValue(callBinding.operand(4)))) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Illegal on error behavior 'EMPTY OBJECT' for return type: %s", type));
            }
            return false;
        }
        if (SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT.equals(SqlJsonQueryFunctionWrapper.getEnumValue(callBinding.operand(3)))) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Illegal on empty behavior 'EMPTY OBJECT' for return type: %s", type));
            }
            return false;
        }
        return true;
    }

    private static <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)Objects.requireNonNull(((SqlLiteral)operand).getValue(), "operand.value"));
    }

    private static RelDataType explicitTypeSpec(SqlOperatorBinding opBinding) {
        if (opBinding.getOperandCount() >= 6) {
            return opBinding.getOperandType(5);
        }
        return null;
    }
}

