/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.LookupJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.DeltaJoinUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtils;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.collector.TableFunctionResultFuture;
import org.apache.flink.table.runtime.generated.GeneratedResultFuture;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.StreamingDeltaJoinOperatorFactory;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.deltajoin.AsyncDeltaJoinRunner;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-delta-join", version=1, producedTransformations={"delta-join"}, consumedOptions={"table.exec.async-lookup.buffer-capacity", "table.exec.async-lookup.timeout"}, minPlanVersion=FlinkVersion.v2_1, minStateVersion=FlinkVersion.v2_1)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecDeltaJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    protected static final Logger LOG = LoggerFactory.getLogger(StreamExecDeltaJoin.class);
    public static final String DELTA_JOIN_TRANSFORMATION = "delta-join";
    private static final String FIELD_NAME_LEFT_JOIN_KEYS = "leftJoinKeys";
    private static final String FIELD_NAME_RIGHT_JOIN_KEYS = "rightJoinKeys";
    private static final String FIELD_NAME_LOOKUP_RIGHT_TABLE_JOIN_SPEC = "lookupRightTableJoinSpec";
    private static final String FIELD_NAME_LOOKUP_LEFT_TABLE_JOIN_SPEC = "lookupLeftTableJoinSpec";
    private static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_ASYNC_OPTIONS = "asyncOptions";
    @JsonProperty(value="joinType")
    private final FlinkJoinType flinkJoinType;
    @JsonProperty(value="asyncOptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final FunctionCallUtils.AsyncOptions asyncLookupOptions;
    @JsonProperty(value="leftJoinKeys")
    private final int[] leftJoinKeys;
    @JsonProperty(value="lookupRightTableJoinSpec")
    private final DeltaJoinSpec lookupRightTableJoinSpec;
    @JsonProperty(value="rightJoinKeys")
    private final int[] rightJoinKeys;
    @JsonProperty(value="lookupLeftTableJoinSpec")
    private final DeltaJoinSpec lookupLeftTableJoinSpec;

    public StreamExecDeltaJoin(ReadableConfig tableConfig, FlinkJoinType flinkJoinType, int[] leftJoinKeys, DeltaJoinSpec lookupRightTableJoinSpec, int[] rightJoinKeys, DeltaJoinSpec lookupLeftTableJoinSpec, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description, FunctionCallUtils.AsyncOptions asyncLookupOptions) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecDeltaJoin.class), ExecNodeContext.newPersistedConfig(StreamExecDeltaJoin.class, tableConfig), flinkJoinType, leftJoinKeys, lookupRightTableJoinSpec, rightJoinKeys, lookupLeftTableJoinSpec, Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description, asyncLookupOptions);
    }

    @JsonCreator
    public StreamExecDeltaJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinType") FlinkJoinType flinkJoinType, @JsonProperty(value="leftJoinKeys") int[] leftJoinKeys, @JsonProperty(value="lookupRightTableJoinSpec") DeltaJoinSpec lookupRightTableJoinSpec, @JsonProperty(value="rightJoinKeys") int[] rightJoinKeys, @JsonProperty(value="lookupLeftTableJoinSpec") DeltaJoinSpec lookupLeftTableJoinSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="asyncOptions") FunctionCallUtils.AsyncOptions asyncLookupOptions) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.flinkJoinType = flinkJoinType;
        this.leftJoinKeys = leftJoinKeys;
        this.lookupRightTableJoinSpec = lookupRightTableJoinSpec;
        this.rightJoinKeys = rightJoinKeys;
        this.lookupLeftTableJoinSpec = lookupLeftTableJoinSpec;
        this.asyncLookupOptions = asyncLookupOptions;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (!DeltaJoinUtil.isJoinTypeSupported(this.flinkJoinType)) {
            throw new IllegalStateException(String.format("Unsupported join type [%s] for delta join.", this.flinkJoinType));
        }
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftStreamType = (RowType)leftInputEdge.getOutputType();
        RowType rightStreamType = (RowType)rightInputEdge.getOutputType();
        RelOptTable leftTemporalTable = this.lookupLeftTableJoinSpec.getLookupTable().getTemporalTable(planner.getFlinkContext(), ShortcutUtils.unwrapTypeFactory(planner));
        RelOptTable rightTemporalTable = this.lookupRightTableJoinSpec.getLookupTable().getTemporalTable(planner.getFlinkContext(), ShortcutUtils.unwrapTypeFactory(planner));
        Transformation<?> leftInputTransformation = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransformation = rightInputEdge.translateToPlan(planner);
        ClassLoader classLoader = planner.getFlinkContext().getClassLoader();
        RowDataKeySelector leftJoinKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, this.leftJoinKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)leftStreamType));
        RowDataKeySelector rightJoinKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, this.rightJoinKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)rightStreamType));
        StreamOperatorFactory<RowData> operatorFactory = this.createAsyncLookupDeltaJoin(planner, config, leftTemporalTable, rightTemporalTable, this.lookupLeftTableJoinSpec.getLookupKeyMap(), this.lookupRightTableJoinSpec.getLookupKeyMap(), planner.createRelBuilder(), leftStreamType, rightStreamType, leftJoinKeySelector, rightJoinKeySelector, classLoader);
        TwoInputTransformation<?, ?, RowData> transform = ExecNodeUtil.createTwoInputTransformation(leftInputTransformation, rightInputTransformation, this.createTransformationMeta(DELTA_JOIN_TRANSFORMATION, config), operatorFactory, InternalTypeInfo.of((RowType)((RowType)this.getOutputType())), leftInputTransformation.getParallelism(), 0L, false);
        transform.setStateKeySelectors((KeySelector)leftJoinKeySelector, (KeySelector)rightJoinKeySelector);
        transform.setStateKeyType((TypeInformation)leftJoinKeySelector.getProducedType());
        return transform;
    }

    private StreamOperatorFactory<RowData> createAsyncLookupDeltaJoin(PlannerBase planner, ExecNodeConfig config, RelOptTable leftTempTable, RelOptTable rightTempTable, Map<Integer, FunctionCallUtils.FunctionParam> leftLookupKeys, Map<Integer, FunctionCallUtils.FunctionParam> rightLookupKeys, RelBuilder relBuilder, RowType leftStreamType, RowType rightStreamType, RowDataKeySelector leftJoinKeySelector, RowDataKeySelector rightJoinKeySelector, ClassLoader classLoader) {
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(relBuilder).getCatalogManager().getDataTypeFactory();
        AsyncDeltaJoinRunner leftLookupTableAsyncFunction = this.createAsyncDeltaJoinRunner(planner, config, classLoader, dataTypeFactory, leftTempTable, rightTempTable, leftStreamType, rightStreamType, leftLookupKeys, false);
        AsyncDeltaJoinRunner rightLookupTableAsyncFunction = this.createAsyncDeltaJoinRunner(planner, config, classLoader, dataTypeFactory, leftTempTable, rightTempTable, leftStreamType, rightStreamType, rightLookupKeys, true);
        return new StreamingDeltaJoinOperatorFactory(rightLookupTableAsyncFunction, leftLookupTableAsyncFunction, leftJoinKeySelector, rightJoinKeySelector, this.asyncLookupOptions.asyncTimeout, this.asyncLookupOptions.asyncBufferCapacity, leftStreamType, rightStreamType);
    }

    private AsyncDeltaJoinRunner createAsyncDeltaJoinRunner(PlannerBase planner, ExecNodeConfig config, ClassLoader classLoader, DataTypeFactory dataTypeFactory, RelOptTable leftTempTable, RelOptTable rightTempTable, RowType leftStreamSideType, RowType rightStreamSideType, Map<Integer, FunctionCallUtils.FunctionParam> lookupKeys, boolean treatRightAsLookupTable) {
        GeneratedResultFuture<TableFunctionResultFuture<RowData>> lookupSideGeneratedResultFuture;
        RelOptTable lookupTable = treatRightAsLookupTable ? rightTempTable : leftTempTable;
        RowType streamSideType = treatRightAsLookupTable ? leftStreamSideType : rightStreamSideType;
        AsyncTableFunction<?> lookupSideAsyncTableFunction = DeltaJoinUtil.getUnwrappedAsyncLookupFunction(lookupTable, lookupKeys.keySet(), classLoader);
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)config, lookupSideAsyncTableFunction);
        RowType lookupTableSourceRowType = FlinkTypeFactory.toLogicalRowType(lookupTable.getRowType());
        RowType resultRowType = (RowType)this.getOutputType();
        List<FunctionCallUtils.FunctionParam> convertedKeys = Arrays.stream(LookupJoinUtil.getOrderedLookupKeys(lookupKeys.keySet())).mapToObj(lookupKeys::get).collect(Collectors.toList());
        LookupJoinCodeGenerator.GeneratedTableFunctionWithDataType<AsyncFunction<RowData, Object>> lookupSideGeneratedFuncWithType = LookupJoinCodeGenerator.generateAsyncLookupFunction(config, classLoader, dataTypeFactory, (LogicalType)streamSideType, (LogicalType)lookupTableSourceRowType, (LogicalType)resultRowType, convertedKeys, lookupSideAsyncTableFunction, String.join((CharSequence)".", lookupTable.getQualifiedName()));
        DataStructureConverter lookupSideFetcherConverter = DataStructureConverters.getConverter((DataType)lookupSideGeneratedFuncWithType.dataType());
        if (treatRightAsLookupTable) {
            lookupSideGeneratedResultFuture = LookupJoinCodeGenerator.generateTableAsyncCollector(config, classLoader, "TableFunctionResultFuture", streamSideType, lookupTableSourceRowType, JavaScalaConversionUtil.toScala(this.lookupRightTableJoinSpec.getRemainingCondition()));
        } else {
            RexBuilder rexBuilder = new RexBuilder(planner.getTypeFactory());
            Optional<RexNode> newCond = this.lookupLeftTableJoinSpec.getRemainingCondition().map(con -> this.swapInputRefsInCondition(rexBuilder, (RexNode)con, leftStreamSideType, rightStreamSideType));
            lookupSideGeneratedResultFuture = LookupJoinCodeGenerator.generateTableAsyncCollector(config, classLoader, "TableFunctionResultFuture", streamSideType, lookupTableSourceRowType, JavaScalaConversionUtil.toScala(newCond));
        }
        return new AsyncDeltaJoinRunner(lookupSideGeneratedFuncWithType.tableFunc(), lookupSideFetcherConverter, lookupSideGeneratedResultFuture, InternalSerializers.create((RowType)lookupTableSourceRowType), this.asyncLookupOptions.asyncBufferCapacity, treatRightAsLookupTable);
    }

    private RexNode swapInputRefsInCondition(final RexBuilder rexBuilder, RexNode condition, RowType leftType, RowType rightType) {
        int leftFieldCount = leftType.getFieldCount();
        int rightFieldCount = rightType.getFieldCount();
        final int[] adjustments = new int[leftFieldCount + rightFieldCount];
        Arrays.fill(adjustments, 0, leftFieldCount, rightFieldCount);
        Arrays.fill(adjustments, leftFieldCount, leftFieldCount + rightFieldCount, leftFieldCount * -1);
        RexShuttle converter = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                int srcIndex = inputRef.getIndex();
                int destIndex = srcIndex + adjustments[srcIndex];
                RelDataType type = inputRef.getType();
                return rexBuilder.makeInputRef(type, destIndex);
            }
        };
        return condition.accept(converter);
    }
}

