/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractCloseTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CloseTableRegionsProcedure
extends AbstractCloseTableRegionsProcedure<MasterProcedureProtos.CloseTableRegionsProcedureState> {
    public CloseTableRegionsProcedure() {
    }

    public CloseTableRegionsProcedure(TableName tableName) {
        super(tableName);
    }

    @Override
    protected int submitUnassignProcedure(MasterProcedureEnv env, Consumer<TransitRegionStateProcedure> submit) {
        return env.getAssignmentManager().submitUnassignProcedureForDisablingTable(this.tableName, submit);
    }

    @Override
    protected int numberOfUnclosedRegions(MasterProcedureEnv env) {
        return env.getAssignmentManager().numberOfUnclosedRegionsForDisabling(this.tableName);
    }

    @Override
    protected MasterProcedureProtos.CloseTableRegionsProcedureState getState(int stateId) {
        return MasterProcedureProtos.CloseTableRegionsProcedureState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.CloseTableRegionsProcedureState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.CloseTableRegionsProcedureState getInitialState() {
        return MasterProcedureProtos.CloseTableRegionsProcedureState.CLOSE_TABLE_REGIONS_SCHEDULE;
    }

    @Override
    protected MasterProcedureProtos.CloseTableRegionsProcedureState getConfirmState() {
        return MasterProcedureProtos.CloseTableRegionsProcedureState.CLOSE_TABLE_REGIONS_CONFIRM;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloseTableRegionsProcedureStateData data = MasterProcedureProtos.CloseTableRegionsProcedureStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName(this.tableName)).build();
        serializer.serialize(data);
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloseTableRegionsProcedureStateData data = serializer.deserialize(MasterProcedureProtos.CloseTableRegionsProcedureStateData.class);
        this.tableName = ProtobufUtil.toTableName(data.getTableName());
    }
}

