/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.store.InMemoryProcedureIterator;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProtoAndProcedure;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ProcedureTree {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureTree.class);
    private final List<ProtoAndProcedure> validProcs = new ArrayList<ProtoAndProcedure>();
    private final List<ProtoAndProcedure> corruptedProcs = new ArrayList<ProtoAndProcedure>();

    private ProcedureTree(Map<Long, Entry> procMap) {
        List<Entry> rootEntries = this.buildTree(procMap);
        for (Entry rootEntry : rootEntries) {
            this.checkReady(rootEntry, procMap);
        }
        this.checkOrphan(procMap);
        Comparator cmp = (p1, p2) -> Long.compare(p1.getProto().getProcId(), p2.getProto().getProcId());
        Collections.sort(this.validProcs, cmp);
        Collections.sort(this.corruptedProcs, cmp);
    }

    private List<Entry> buildTree(Map<Long, Entry> procMap) {
        ArrayList<Entry> rootEntries = new ArrayList<Entry>();
        procMap.values().forEach(entry -> {
            if (!((Entry)entry).proc.hasParentId()) {
                rootEntries.add((Entry)entry);
            } else {
                Entry parentEntry = (Entry)procMap.get(((Entry)entry).proc.getParentId());
                if (parentEntry != null) {
                    parentEntry.subProcs.add(entry);
                }
            }
        });
        return rootEntries;
    }

    private void collectStackId(Entry entry, Map<Integer, List<Entry>> stackId2Proc, MutableInt maxStackId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Procedure {} stack ids={}", (Object)entry, entry.proc.getStackIdList());
        }
        int n = entry.proc.getStackIdCount();
        for (int i = 0; i < n; ++i) {
            int stackId = entry.proc.getStackId(i);
            if (stackId > maxStackId.intValue()) {
                maxStackId.setValue(stackId);
            }
            stackId2Proc.computeIfAbsent(stackId, k -> new ArrayList()).add(entry);
        }
        entry.subProcs.forEach(e -> this.collectStackId((Entry)e, stackId2Proc, maxStackId));
    }

    private void addAllToCorruptedAndRemoveFromProcMap(Entry entry, Map<Long, Entry> remainingProcMap) {
        this.corruptedProcs.add(new ProtoAndProcedure(entry.proc));
        remainingProcMap.remove(entry.proc.getProcId());
        for (Entry e : entry.subProcs) {
            this.addAllToCorruptedAndRemoveFromProcMap(e, remainingProcMap);
        }
    }

    private void addAllToValidAndRemoveFromProcMap(Entry entry, Map<Long, Entry> remainingProcMap) {
        this.validProcs.add(new ProtoAndProcedure(entry.proc));
        remainingProcMap.remove(entry.proc.getProcId());
        for (Entry e : entry.subProcs) {
            this.addAllToValidAndRemoveFromProcMap(e, remainingProcMap);
        }
    }

    private void checkReady(Entry rootEntry, Map<Long, Entry> remainingProcMap) {
        if (ProcedureUtil.isFinished(rootEntry.proc)) {
            if (!rootEntry.subProcs.isEmpty()) {
                LOG.error("unexpected active children for root-procedure: {}", (Object)rootEntry);
                rootEntry.subProcs.forEach(e -> LOG.error("unexpected active children: {}", e));
                this.addAllToCorruptedAndRemoveFromProcMap(rootEntry, remainingProcMap);
            } else {
                this.addAllToValidAndRemoveFromProcMap(rootEntry, remainingProcMap);
            }
            return;
        }
        HashMap<Integer, List<Entry>> stackId2Proc = new HashMap<Integer, List<Entry>>();
        MutableInt maxStackId = new MutableInt(Integer.MIN_VALUE);
        this.collectStackId(rootEntry, stackId2Proc, maxStackId);
        boolean valid = true;
        for (int i = 0; i <= maxStackId.intValue(); ++i) {
            List entries = (List)stackId2Proc.get(i);
            if (entries == null) {
                LOG.error("Missing stack id {}, max stack id is {}, root procedure is {}", new Object[]{i, maxStackId, rootEntry});
                valid = false;
                continue;
            }
            if (entries.size() <= 1) continue;
            LOG.error("Multiple procedures {} have the same stack id {}, max stack id is {}, root procedure is {}", new Object[]{entries, i, maxStackId, rootEntry});
            valid = false;
        }
        if (valid) {
            this.addAllToValidAndRemoveFromProcMap(rootEntry, remainingProcMap);
        } else {
            this.addAllToCorruptedAndRemoveFromProcMap(rootEntry, remainingProcMap);
        }
    }

    private void checkOrphan(Map<Long, Entry> procMap) {
        procMap.values().forEach(entry -> {
            LOG.error("Orphan procedure: {}", entry);
            this.corruptedProcs.add(new ProtoAndProcedure(((Entry)entry).proc));
        });
    }

    public ProcedureStore.ProcedureIterator getValidProcs() {
        return new InMemoryProcedureIterator(this.validProcs);
    }

    public ProcedureStore.ProcedureIterator getCorruptedProcs() {
        return new InMemoryProcedureIterator(this.corruptedProcs);
    }

    public static ProcedureTree build(Collection<ProcedureProtos.Procedure> procedures) {
        HashMap<Long, Entry> procMap = new HashMap<Long, Entry>();
        for (ProcedureProtos.Procedure proc : procedures) {
            procMap.put(proc.getProcId(), new Entry(proc));
        }
        return new ProcedureTree(procMap);
    }

    private static final class Entry {
        private final ProcedureProtos.Procedure proc;
        private final List<Entry> subProcs = new ArrayList<Entry>();

        public Entry(ProcedureProtos.Procedure proc) {
            this.proc = proc;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Procedure(pid=");
            sb.append(this.proc.getProcId());
            sb.append(", ppid=");
            sb.append(this.proc.hasParentId() ? this.proc.getParentId() : -1L);
            sb.append(", class=");
            sb.append(this.proc.getClassName());
            sb.append(")");
            return sb.toString();
        }
    }
}

