/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestDetermineRSGroupInfoForTable {
    private static final Logger LOG = LoggerFactory.getLogger(TestDetermineRSGroupInfoForTable.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDetermineRSGroupInfoForTable.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static HMaster master;
    private static Admin admin;
    private static RSGroupInfoManager rsGroupInfoManager;
    private static RSGroupAdminClient rsGroupAdminClient;
    private static final String GROUP_NAME = "rsg";
    private static final String NAMESPACE_NAME = "ns";
    private static final String OTHER_NAMESPACE_NAME = "other";
    private static final TableName TABLE_NAME;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        UTIL.startMiniCluster(5);
        master = UTIL.getMiniHBaseCluster().getMaster();
        admin = UTIL.getAdmin();
        rsGroupAdminClient = new RSGroupAdminClient(UTIL.getConnection());
        UTIL.waitFor(60000L, () -> master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline());
        List cps = master.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class);
        Assert.assertTrue((cps.size() > 0 ? 1 : 0) != 0);
        rsGroupInfoManager = ((RSGroupAdminEndpoint)cps.get(0)).getGroupInfoManager();
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        rsGroupAdminClient.addRSGroup(GROUP_NAME);
        rsGroupAdminClient.moveServers(Collections.singleton(rs.getServerName().getAddress()), GROUP_NAME);
        admin.createNamespace(NamespaceDescriptor.create((String)NAMESPACE_NAME).addConfiguration("hbase.rsgroup.name", GROUP_NAME).build());
        admin.createNamespace(NamespaceDescriptor.create((String)OTHER_NAMESPACE_NAME).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        admin.deleteNamespace(NAMESPACE_NAME);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testByDefault() throws IOException {
        RSGroupInfo group = rsGroupInfoManager.determineRSGroupInfoForTable(TableName.valueOf((String)"tb"));
        Assert.assertEquals((Object)group.getName(), (Object)"default");
    }

    @Test
    public void testDetermineByNamespaceConfig() throws IOException {
        RSGroupInfo group = rsGroupInfoManager.determineRSGroupInfoForTable(TABLE_NAME);
        Assert.assertEquals((Object)group.getName(), (Object)GROUP_NAME);
        group = rsGroupInfoManager.determineRSGroupInfoForTable(TableName.valueOf((String)OTHER_NAMESPACE_NAME, (String)"tb"));
        Assert.assertEquals((Object)group.getName(), (Object)"default");
    }

    @Test
    public void testDetermineByScript() throws IOException {
        RSGroupInfoManagerImpl.RSGroupMappingScript script = (RSGroupInfoManagerImpl.RSGroupMappingScript)Mockito.mock(RSGroupInfoManagerImpl.RSGroupMappingScript.class);
        Mockito.when((Object)script.getRSGroup(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)GROUP_NAME);
        RSGroupInfoManagerImpl.RSGroupMappingScript oldScript = ((RSGroupInfoManagerImpl)TestDetermineRSGroupInfoForTable.rsGroupInfoManager).script;
        ((RSGroupInfoManagerImpl)TestDetermineRSGroupInfoForTable.rsGroupInfoManager).script = script;
        RSGroupInfo group = rsGroupInfoManager.determineRSGroupInfoForTable(TABLE_NAME);
        Assert.assertEquals((Object)group.getName(), (Object)GROUP_NAME);
        ((RSGroupInfoManagerImpl)TestDetermineRSGroupInfoForTable.rsGroupInfoManager).script = oldScript;
    }

    static {
        TABLE_NAME = TableName.valueOf((String)NAMESPACE_NAME, (String)"tb");
    }
}

