/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;

public final class HashAlgorithmRegistry {
    private static final Map<String, HashAlgorithm> REGISTRY = new HashMap<String, HashAlgorithm>();

    private HashAlgorithmRegistry() {
    }

    public static synchronized void registerHashAlgorithm(String name, HashAlgorithm alg) {
        HashAlgorithmRegistry.validateName(name);
        HashAlgorithmRegistry.validateAlgorithm(alg);
        REGISTRY.put(name.toLowerCase(), alg);
    }

    public static synchronized HashAlgorithm lookupHashAlgorithm(String name) {
        HashAlgorithmRegistry.validateName(name);
        return REGISTRY.get(name.toLowerCase());
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("HashAlgorithm name should beprovided in order to perform the lookup: either NULL or empty string has been provided");
        }
    }

    private static void validateAlgorithm(HashAlgorithm alg) {
        if (alg == null) {
            throw new IllegalArgumentException("HashAlgorithm instance should be provided in order to register a new algorithm");
        }
    }

    static {
        for (DefaultHashAlgorithm alg : DefaultHashAlgorithm.values()) {
            HashAlgorithmRegistry.registerHashAlgorithm(alg.name().replace("_HASH", "").toLowerCase(), alg);
        }
    }
}

