/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestSequenceIdMonotonicallyIncreasing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSequenceIdMonotonicallyIncreasing.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME = TableName.valueOf((String)"test");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        Admin admin = UTIL.getAdmin();
        if (admin.tableExists(NAME)) {
            admin.disableTable(NAME);
            admin.deleteTable(NAME);
        }
    }

    private Table createTable(boolean multiRegions) throws IOException {
        if (multiRegions) {
            return UTIL.createTable(NAME, CF, (byte[][])new byte[][]{Bytes.toBytes((int)1)});
        }
        return UTIL.createTable(NAME, CF);
    }

    private long getMaxSeqId(HRegionServer rs, RegionInfo region) throws IOException {
        Path walFile = ((AbstractFSWAL)rs.getWAL(null)).getCurrentFileName();
        long maxSeqId = -1L;
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)UTIL.getTestFileSystem(), (Path)walFile, (Configuration)UTIL.getConfiguration());){
            WAL.Entry entry;
            while ((entry = reader.next()) != null) {
                if (!Bytes.equals((byte[])region.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName())) continue;
                maxSeqId = Math.max(maxSeqId, entry.getKey().getSequenceId());
            }
        }
        return maxSeqId;
    }

    @Test
    public void testSplit() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        try (Table table = this.createTable(false);){
            table.put(new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
        }
        UTIL.flush(NAME);
        HRegionServer rs = UTIL.getRSForFirstRegionInTable(NAME);
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        UTIL.getAdmin().splitRegionAsync(region.getRegionName(), Bytes.toBytes((int)1)).get(1L, TimeUnit.MINUTES);
        long maxSeqId = this.getMaxSeqId(rs, region);
        RegionLocator locator = UTIL.getConnection().getRegionLocator(NAME);
        HRegionLocation locA = locator.getRegionLocation(Bytes.toBytes((int)0), true);
        HRegionLocation locB = locator.getRegionLocation(Bytes.toBytes((int)1), true);
        Assert.assertEquals((long)(maxSeqId + 1L), (long)locA.getSeqNum());
        Assert.assertEquals((long)(maxSeqId + 1L), (long)locB.getSeqNum());
    }

    @Test
    public void testMerge() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        try (Table table = this.createTable(true);){
            table.put(new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
            table.put(new Put(Bytes.toBytes((int)2)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
        }
        UTIL.flush(NAME);
        MiniHBaseCluster cluster = UTIL.getMiniHBaseCluster();
        List<HRegion> regions = cluster.getRegions(NAME);
        HRegion regionA = regions.get(0);
        HRegion regionB = regions.get(1);
        HRegionServer rsA = cluster.getRegionServer(cluster.getServerWith(regionA.getRegionInfo().getRegionName()));
        HRegionServer rsB = cluster.getRegionServer(cluster.getServerWith(regionB.getRegionInfo().getRegionName()));
        UTIL.getAdmin().mergeRegionsAsync(regionA.getRegionInfo().getRegionName(), regionB.getRegionInfo().getRegionName(), false).get(1L, TimeUnit.MINUTES);
        long maxSeqIdA = this.getMaxSeqId(rsA, regionA.getRegionInfo());
        long maxSeqIdB = this.getMaxSeqId(rsB, regionB.getRegionInfo());
        HRegionLocation loc = UTIL.getConnection().getRegionLocator(NAME).getRegionLocation(Bytes.toBytes((int)0), true);
        Assert.assertEquals((long)(Math.max(maxSeqIdA, maxSeqIdB) + 1L), (long)loc.getSeqNum());
    }
}

