/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.slive.BadFileException;
import org.apache.hadoop.fs.slive.DataHasher;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.Timer;

class DataVerifier {
    private static final int BYTES_PER_LONG = 8;
    private int bufferSize;

    DataVerifier(int bufferSize) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("Buffer size must be greater than or equal to 8");
        }
        if (bufferSize % 8 != 0) {
            throw new IllegalArgumentException("Buffer size must be a multiple of 8");
        }
        this.bufferSize = bufferSize;
    }

    DataVerifier() {
        this(65536);
    }

    private VerifyInfo verifyBuffer(ByteBuffer buf, int size, long startOffset, DataHasher hasher) {
        ByteBuffer cmpBuf = ByteBuffer.wrap(new byte[8]);
        long hashOffset = startOffset;
        long chunksSame = 0L;
        long chunksDifferent = 0L;
        for (long i = 0L; i < (long)size; ++i) {
            cmpBuf.put(buf.get());
            if (cmpBuf.hasRemaining()) continue;
            cmpBuf.rewind();
            long receivedData = cmpBuf.getLong();
            cmpBuf.rewind();
            long expected = hasher.generate(hashOffset);
            hashOffset += 8L;
            if (receivedData == expected) {
                ++chunksSame;
                continue;
            }
            ++chunksDifferent;
        }
        if (cmpBuf.hasRemaining() && cmpBuf.position() != 0) {
            int curSize = cmpBuf.position();
            while (cmpBuf.hasRemaining()) {
                cmpBuf.put((byte)0);
            }
            long expected = hasher.generate(hashOffset);
            ByteBuffer tempBuf = ByteBuffer.wrap(new byte[8]);
            tempBuf.putLong(expected);
            tempBuf.position(curSize);
            while (tempBuf.hasRemaining()) {
                tempBuf.put((byte)0);
            }
            cmpBuf.rewind();
            tempBuf.rewind();
            if (cmpBuf.equals(tempBuf)) {
                ++chunksSame;
            } else {
                ++chunksDifferent;
            }
        }
        return new VerifyInfo(chunksSame, chunksDifferent);
    }

    private long determineOffset(long byteRead) {
        if (byteRead < 0L) {
            byteRead = 0L;
        }
        return byteRead / 8L * 8L;
    }

    VerifyOutput verifyFile(long byteAm, DataInputStream in) throws IOException, BadFileException {
        return this.verifyBytes(byteAm, 0L, in);
    }

    private VerifyOutput verifyBytes(long byteAm, long bytesRead, DataInputStream in) throws IOException, BadFileException {
        if (byteAm <= 0L) {
            return new VerifyOutput(0L, 0L, 0L, 0L);
        }
        long chunksSame = 0L;
        long chunksDifferent = 0L;
        long readTime = 0L;
        long bytesLeft = byteAm;
        long bufLeft = 0L;
        long bufRead = 0L;
        long seqNum = 0L;
        DataHasher hasher = null;
        ByteBuffer readBuf = ByteBuffer.wrap(new byte[this.bufferSize]);
        while (bytesLeft > 0L) {
            int bufSize;
            if (bufLeft <= 0L) {
                if (bytesLeft < (long)DataWriter.getHeaderLength()) break;
                ReadInfo header = null;
                try {
                    header = this.readHeader(in);
                }
                catch (EOFException e) {
                    break;
                }
                ++seqNum;
                hasher = new DataHasher(header.getHashValue());
                bufLeft = header.getByteAm();
                readTime += header.getTimeTaken();
                bytesRead += header.getBytesRead();
                bufRead = 0L;
                if (bufLeft > (bytesLeft -= header.getBytesRead())) {
                    bufLeft = bytesLeft;
                }
                if (bufLeft <= 0L) continue;
            }
            if (bytesLeft < (long)(bufSize = this.bufferSize)) {
                bufSize = (int)bytesLeft;
            }
            if (bufLeft < (long)bufSize) {
                bufSize = (int)bufLeft;
            }
            try {
                readBuf.rewind();
                long startTime = Timer.now();
                in.readFully(readBuf.array(), 0, bufSize);
                readTime += Timer.elapsed(startTime);
            }
            catch (EOFException e) {
                throw new BadFileException("Could not read the number of expected data bytes " + bufSize + " due to unexpected end of file during sequence " + seqNum, e);
            }
            bytesRead += (long)bufSize;
            bytesLeft -= (long)bufSize;
            bufLeft -= (long)bufSize;
            readBuf.rewind();
            long vOffset = this.determineOffset(bufRead);
            bufRead += (long)bufSize;
            VerifyInfo verifyRes = this.verifyBuffer(readBuf, bufSize, vOffset, hasher);
            chunksSame += verifyRes.getSame();
            chunksDifferent += verifyRes.getDifferent();
        }
        return new VerifyOutput(chunksSame, chunksDifferent, bytesRead, readTime);
    }

    ReadInfo readHeader(DataInputStream in) throws IOException, BadFileException {
        int headerLen = DataWriter.getHeaderLength();
        ByteBuffer headerBuf = ByteBuffer.wrap(new byte[headerLen]);
        long elapsed = 0L;
        long startTime = Timer.now();
        in.readFully(headerBuf.array());
        elapsed += Timer.elapsed(startTime);
        headerBuf.rewind();
        long hashValue = headerBuf.getLong();
        long byteAvailable = headerBuf.getLong();
        if (byteAvailable < 0L) {
            throw new BadFileException("Invalid negative amount " + byteAvailable + " determined for header data amount");
        }
        return new ReadInfo(byteAvailable, hashValue, elapsed, headerLen);
    }

    private static class VerifyInfo {
        private long same;
        private long different;

        VerifyInfo(long same, long different) {
            this.same = same;
            this.different = different;
        }

        long getSame() {
            return this.same;
        }

        long getDifferent() {
            return this.different;
        }
    }

    private static class ReadInfo {
        private long byteAm;
        private long hash;
        private long timeTaken;
        private long bytesRead;

        ReadInfo(long byteAm, long hash, long timeTaken, long bytesRead) {
            this.byteAm = byteAm;
            this.hash = hash;
            this.timeTaken = timeTaken;
            this.bytesRead = bytesRead;
        }

        long getByteAm() {
            return this.byteAm;
        }

        long getHashValue() {
            return this.hash;
        }

        long getTimeTaken() {
            return this.timeTaken;
        }

        long getBytesRead() {
            return this.bytesRead;
        }
    }

    static class VerifyOutput {
        private long same;
        private long different;
        private long read;
        private long readTime;

        VerifyOutput(long sameChunks, long differentChunks, long readBytes, long readTime) {
            this.same = sameChunks;
            this.different = differentChunks;
            this.read = readBytes;
            this.readTime = readTime;
        }

        long getReadTime() {
            return this.readTime;
        }

        long getBytesRead() {
            return this.read;
        }

        long getChunksSame() {
            return this.same;
        }

        long getChunksDifferent() {
            return this.different;
        }

        public String toString() {
            return "Bytes read = " + this.getBytesRead() + " same = " + this.getChunksSame() + " different = " + this.getChunksDifferent() + " in " + this.getReadTime() + " milliseconds";
        }
    }
}

