/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerReacquisitionContext {
    private final Container container;
    private final String user;
    private final ContainerId containerId;

    private ContainerReacquisitionContext(Builder builder) {
        this.container = builder.container;
        this.user = builder.user;
        this.containerId = builder.containerId;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getUser() {
        return this.user;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public static final class Builder {
        private Container container;
        private String user;
        private ContainerId containerId;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setContainerId(ContainerId containerId) {
            this.containerId = containerId;
            return this;
        }

        public ContainerReacquisitionContext build() {
            return new ContainerReacquisitionContext(this);
        }
    }
}

