/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.BatchScanResultCache;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestBatchScanResultCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBatchScanResultCache.class);
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private BatchScanResultCache resultCache;

    @Before
    public void setUp() {
        this.resultCache = new BatchScanResultCache(4);
    }

    @After
    public void tearDown() {
        this.resultCache.clear();
        this.resultCache = null;
    }

    static Cell createCell(byte[] cf, int key, int cq) {
        return new KeyValue(Bytes.toBytes((int)key), cf, Bytes.toBytes((String)("cq" + cq)), Bytes.toBytes((int)key));
    }

    static Cell[] createCells(byte[] cf, int key, int numCqs) {
        Cell[] cells = new Cell[numCqs];
        for (int i = 0; i < numCqs; ++i) {
            cells[i] = TestBatchScanResultCache.createCell(cf, key, i);
        }
        return cells;
    }

    private void assertResultEquals(Result result, int key, int start, int to) {
        Assert.assertEquals((long)(to - start), (long)result.size());
        for (int i = start; i < to; ++i) {
            Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        Assert.assertEquals((Object)(to - start == 4 ? 1 : 0), (Object)result.mayHaveMoreCellsInRow());
    }

    @Test
    public void test() throws IOException {
        Assert.assertSame((Object)ScanResultCache.EMPTY_RESULT_ARRAY, (Object)this.resultCache.addAndGet(ScanResultCache.EMPTY_RESULT_ARRAY, false));
        Assert.assertSame((Object)ScanResultCache.EMPTY_RESULT_ARRAY, (Object)this.resultCache.addAndGet(ScanResultCache.EMPTY_RESULT_ARRAY, true));
        Cell[] cells1 = TestBatchScanResultCache.createCells(CF, 1, 10);
        Cell[] cells2 = TestBatchScanResultCache.createCells(CF, 2, 10);
        Cell[] cells3 = TestBatchScanResultCache.createCells(CF, 3, 10);
        Assert.assertEquals((long)0L, (long)this.resultCache.addAndGet(new Result[]{Result.create((Cell[])Arrays.copyOf(cells1, 3), null, (boolean)false, (boolean)true)}, false).length);
        Result[] results = this.resultCache.addAndGet(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells1, 3, 7), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells1, 7, 10), null, (boolean)false, (boolean)true)}, false);
        Assert.assertEquals((long)2L, (long)results.length);
        this.assertResultEquals(results[0], 1, 0, 4);
        this.assertResultEquals(results[1], 1, 4, 8);
        results = this.resultCache.addAndGet(ScanResultCache.EMPTY_RESULT_ARRAY, false);
        Assert.assertEquals((long)1L, (long)results.length);
        this.assertResultEquals(results[0], 1, 8, 10);
        results = this.resultCache.addAndGet(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells2, 0, 4), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells2, 4, 8), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells2, 8, 10), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 0, 4), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 4, 8), null, (boolean)false, (boolean)true), Result.create((Cell[])Arrays.copyOfRange(cells3, 8, 10), null, (boolean)false, (boolean)false)}, false);
        Assert.assertEquals((long)6L, (long)results.length);
        this.assertResultEquals(results[0], 2, 0, 4);
        this.assertResultEquals(results[1], 2, 4, 8);
        this.assertResultEquals(results[2], 2, 8, 10);
        this.assertResultEquals(results[3], 3, 0, 4);
        this.assertResultEquals(results[4], 3, 4, 8);
        this.assertResultEquals(results[5], 3, 8, 10);
    }
}

