/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.master.assignment.TestAssignmentManagerBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAMServerFailedOpen
extends TestAssignmentManagerBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAMServerFailedOpen.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAMServerFailedOpen.class);

    @Override
    protected int getAssignMaxAttempts() {
        return 10;
    }

    @Test
    public void testServerNotYetRunning() throws Exception {
        this.testRetriesExhaustedFailure(TableName.valueOf((String)this.name.getMethodName()), new TestAssignmentManagerBase.ServerNotYetRunningRsExecutor());
    }

    private void testRetriesExhaustedFailure(TableName tableName, TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(executor);
        try {
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
            Assert.fail((String)"unexpected assign completion");
        }
        catch (RetriesExhaustedException e) {
            LOG.info("expected exception from assign operation: " + e.getMessage(), (Throwable)e);
        }
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor(this));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
    }

    @Test
    public void testDoNotRetryExceptionOnAssignment() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testFailedOpen(TableName.valueOf((String)"testDoNotRetryExceptionOnAssignment"), new TestAssignmentManagerBase.FaultyRsExecutor((IOException)((Object)new DoNotRetryIOException("test do not retry fault"))));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.assignFailedCount + 1L), (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    private void testFailedOpen(TableName tableName, TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(executor);
        try {
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
            Assert.fail((String)"unexpected assign completion");
        }
        catch (RetriesExhaustedException e) {
            LOG.info("REGION STATE " + this.am.getRegionStates().getRegionStateNode(hri));
            LOG.info("expected exception from assign operation: " + e.getMessage(), (Throwable)e);
            Assert.assertEquals((Object)true, (Object)this.am.getRegionStates().getRegionState(hri).isFailedOpen());
        }
    }

    @Test
    public void testCallQueueTooBigExceptionOnAssignment() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testFailedOpen(TableName.valueOf((String)"testCallQueueTooBigExceptionOnAssignment"), new TestAssignmentManagerBase.FaultyRsExecutor((IOException)new CallQueueTooBigException("test do not retry fault")));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.assignFailedCount + 1L), (long)this.assignProcMetrics.getFailedCounter().getCount());
    }
}

