/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerScheduler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ResourceUtilizationTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationBasedResourceUtilizationTracker
implements ResourceUtilizationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AllocationBasedResourceUtilizationTracker.class);
    private static final long LEFT_SHIFT_MB_IN_BYTES = 20L;
    private static final int RIGHT_SHIFT_BYTES_IN_MB = 20;
    private ResourceUtilization containersAllocation = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    private ContainerScheduler scheduler;

    AllocationBasedResourceUtilizationTracker(ContainerScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public ResourceUtilization getCurrentUtilization() {
        return this.containersAllocation;
    }

    @Override
    public void addContainerResources(Container container) {
        ContainersMonitor.increaseResourceUtilization(this.getContainersMonitor(), this.containersAllocation, container.getResource());
    }

    @Override
    public void subtractContainerResource(Container container) {
        ContainersMonitor.decreaseResourceUtilization(this.getContainersMonitor(), this.containersAllocation, container.getResource());
    }

    @Override
    public boolean hasResourcesAvailable(Container container) {
        return this.hasResourcesAvailable(container.getResource());
    }

    private static long convertMBToBytes(long memMB) {
        return memMB << 20;
    }

    private static long convertBytesToMB(long bytes) {
        return bytes >> 20;
    }

    @Override
    public boolean hasResourcesAvailable(Resource resource) {
        long pMemBytes = AllocationBasedResourceUtilizationTracker.convertMBToBytes(resource.getMemorySize());
        long vmemBytes = (long)(this.getContainersMonitor().getVmemRatio() * (float)pMemBytes);
        return this.hasResourcesAvailable(pMemBytes, vmemBytes, resource.getVirtualCores());
    }

    private boolean hasResourcesAvailable(long pMemBytes, long vMemBytes, int cpuVcores) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pMemCheck [current={} + asked={} > allowed={}]", new Object[]{this.containersAllocation.getPhysicalMemory(), AllocationBasedResourceUtilizationTracker.convertBytesToMB(pMemBytes), AllocationBasedResourceUtilizationTracker.convertBytesToMB(this.getContainersMonitor().getPmemAllocatedForContainers())});
        }
        if ((long)this.containersAllocation.getPhysicalMemory() + AllocationBasedResourceUtilizationTracker.convertBytesToMB(pMemBytes) > AllocationBasedResourceUtilizationTracker.convertBytesToMB(this.getContainersMonitor().getPmemAllocatedForContainers())) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("before vMemCheck[isEnabled={}, current={} + asked={} > allowed={}]", new Object[]{this.getContainersMonitor().isVmemCheckEnabled(), this.containersAllocation.getVirtualMemory(), AllocationBasedResourceUtilizationTracker.convertBytesToMB(vMemBytes), AllocationBasedResourceUtilizationTracker.convertBytesToMB(this.getContainersMonitor().getVmemAllocatedForContainers())});
        }
        if (this.getContainersMonitor().isVmemCheckEnabled() && (long)this.containersAllocation.getVirtualMemory() + AllocationBasedResourceUtilizationTracker.convertBytesToMB(vMemBytes) > AllocationBasedResourceUtilizationTracker.convertBytesToMB(this.getContainersMonitor().getVmemAllocatedForContainers())) {
            return false;
        }
        LOG.debug("before cpuCheck [asked={} > allowed={}]", (Object)Float.valueOf(this.containersAllocation.getCPU()), (Object)this.getContainersMonitor().getVCoresAllocatedForContainers());
        return !(this.containersAllocation.getCPU() + (float)cpuVcores > (float)this.getContainersMonitor().getVCoresAllocatedForContainers());
    }

    public ContainersMonitor getContainersMonitor() {
        return this.scheduler.getContainersMonitor();
    }
}

