/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sharedcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.sharedcache.SharedCacheChecksum;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class SharedCacheChecksumFactory {
    private static final ConcurrentMap<Class<? extends SharedCacheChecksum>, SharedCacheChecksum> instances = new ConcurrentHashMap<Class<? extends SharedCacheChecksum>, SharedCacheChecksum>();
    private static final Class<? extends SharedCacheChecksum> defaultAlgorithm;

    public static SharedCacheChecksum getChecksum(Configuration conf) {
        Class clazz = conf.getClass("yarn.sharedcache.checksum.algo.impl", defaultAlgorithm, SharedCacheChecksum.class);
        SharedCacheChecksum checksum = (SharedCacheChecksum)instances.get(clazz);
        if (checksum == null) {
            try {
                checksum = (SharedCacheChecksum)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
                SharedCacheChecksum old = instances.putIfAbsent(clazz, checksum);
                if (old != null) {
                    checksum = old;
                }
            }
            catch (Exception e) {
                throw new YarnRuntimeException((Throwable)e);
            }
        }
        return checksum;
    }

    static {
        try {
            defaultAlgorithm = Class.forName("org.apache.hadoop.yarn.sharedcache.ChecksumSHA256Impl");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

