/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;

public final class RootCalculationDriver
extends ResourceCalculationDriver {
    private final AbstractQueueCapacityCalculator rootCalculator;

    public RootCalculationDriver(CSQueue rootQueue, QueueCapacityUpdateContext updateContext, AbstractQueueCapacityCalculator rootCalculator, Collection<String> definedResources) {
        super(rootQueue, updateContext, Collections.emptyMap(), definedResources);
        this.rootCalculator = rootCalculator;
    }

    @Override
    public void calculateResources() {
        for (String label : this.queue.getConfiguredNodeLabels()) {
            for (QueueCapacityVector.QueueCapacityVectorEntry capacityVectorEntry : this.queue.getConfiguredCapacityVector(label)) {
                String resourceName = capacityVectorEntry.getResourceName();
                CalculationContext context = new CalculationContext(resourceName, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, this.queue);
                double minimumResource = this.rootCalculator.calculateMinimumResource(this, context, label);
                double maximumResource = this.rootCalculator.calculateMaximumResource(this, context, label);
                long roundedMinResource = (long)this.roundingStrategy.getRoundedResource(minimumResource, capacityVectorEntry);
                long roundedMaxResource = (long)this.roundingStrategy.getRoundedResource(maximumResource, this.queue.getConfiguredMaxCapacityVector(label).getResource(resourceName));
                this.queue.getQueueResourceQuotas().getEffectiveMinResource(label).setResourceValue(resourceName, roundedMinResource);
                this.queue.getQueueResourceQuotas().getEffectiveMaxResource(label).setResourceValue(resourceName, roundedMaxResource);
            }
            this.rootCalculator.updateCapacitiesAfterCalculation(this, this.queue, label);
        }
        this.rootCalculator.calculateResourcePrerequisites(this);
    }
}

