/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.converters.PageOpenAPIConverter;
import org.springdoc.core.converters.PageableOpenAPIConverter;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.customizers.DataRestDelegatingMethodParameterCustomizer;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.RepositoryRestConfigurationProvider;
import org.springdoc.core.providers.SpringDataWebPropertiesProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.web.PagedModel;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.SpringDataWebSettings;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={org.springframework.data.domain.Pageable.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocPageableConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.pageable-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    PageableOpenAPIConverter pageableOpenAPIConverter(ObjectMapperProvider objectMapperProvider) {
        SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceParameterObjectWithClass(PageRequest.class, Pageable.class);
        return new PageableOpenAPIConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={PagedModel.class, SpringDataWebSettings.class})
    @Lazy(value=false)
    PageOpenAPIConverter pageOpenAPIConverter(Optional<SpringDataWebSettings> settings, ObjectMapperProvider objectMapperProvider) {
        boolean replacePageWithPagedModel = settings.map(SpringDataWebSettings::pageSerializationMode).map(arg_0 -> EnableSpringDataWebSupport.PageSerializationMode.VIA_DTO.equals(arg_0)).orElse(false);
        return new PageOpenAPIConverter(replacePageWithPagedModel, objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    DataRestDelegatingMethodParameterCustomizer dataRestDelegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfiguration) {
        return new DataRestDelegatingMethodParameterCustomizer(optionalSpringDataWebPropertiesProvider, optionalRepositoryRestConfiguration);
    }
}

