/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.SessionAttribute;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.server.MissingRequestValueException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SessionAttributeMethodArgumentResolver
extends AbstractNamedValueArgumentResolver {
    public SessionAttributeMethodArgumentResolver(ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(SessionAttribute.class);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        SessionAttribute ann = (SessionAttribute)parameter.getParameterAnnotation(SessionAttribute.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No SessionAttribute annotation");
        return new AbstractNamedValueArgumentResolver.NamedValueInfo(ann.name(), ann.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange2) {
        return exchange2.getSession().filter(session -> session.getAttribute(name) != null).map(session -> session.getAttribute(name));
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingRequestValueException(name, parameter.getNestedParameterType(), "session attribute", parameter);
    }
}

