/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.tracer.common.SpanContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusSimpleclientScrapeEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="prometheus")
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    PrometheusConfig prometheusConfig(PrometheusProperties prometheusProperties) {
        return new PrometheusPropertiesConfigAdapter(prometheusProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig prometheusConfig, PrometheusRegistry prometheusRegistry, Clock clock, ObjectProvider<SpanContext> spanContext) {
        return new PrometheusMeterRegistry(prometheusConfig, prometheusRegistry, clock, (SpanContext)spanContext.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    PrometheusRegistry prometheusRegistry() {
        return new PrometheusRegistry();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(value=PrometheusScrapeEndpoint.class)
    static class PrometheusScrapeEndpointConfiguration {
        PrometheusScrapeEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={PrometheusScrapeEndpoint.class, PrometheusSimpleclientScrapeEndpoint.class})
        PrometheusScrapeEndpoint prometheusEndpoint(PrometheusRegistry prometheusRegistry, PrometheusConfig prometheusConfig) {
            return new PrometheusScrapeEndpoint(prometheusRegistry, prometheusConfig.prometheusProperties());
        }
    }
}

