/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

public class MailServerConfig {
    @NotNull(message="Type cannot be empty")
    private @NotNull(message="Type cannot be empty") Integer type;
    @NotBlank(message="Mail host cannot be empty")
    private @NotBlank(message="Mail host cannot be empty") String emailHost;
    @NotBlank(message="Username cannot be empty")
    @Email
    private @NotBlank(message="Username cannot be empty") @Email String emailUsername;
    @NotBlank(message="Password cannot be empty")
    private @NotBlank(message="Password cannot be empty") String emailPassword;
    @NotNull(message="Mail port cannot be null")
    @Max(message="Mail port must be less than or equal to 65535", value=65535L)
    @Min(message="Mail port must be greater than or equal to 1", value=1L)
    private @NotNull(message="Mail port cannot be null") @Max(message="Mail port must be less than or equal to 65535", value=65535L) @Min(message="Mail port must be greater than or equal to 1", value=1L) Integer emailPort;
    private boolean emailSsl = true;
    private boolean emailStarttls = false;
    private boolean enable = true;

    public Integer getType() {
        return this.type;
    }

    public String getEmailHost() {
        return this.emailHost;
    }

    public String getEmailUsername() {
        return this.emailUsername;
    }

    public String getEmailPassword() {
        return this.emailPassword;
    }

    public Integer getEmailPort() {
        return this.emailPort;
    }

    public boolean isEmailSsl() {
        return this.emailSsl;
    }

    public boolean isEmailStarttls() {
        return this.emailStarttls;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setEmailHost(String emailHost) {
        this.emailHost = emailHost;
    }

    public void setEmailUsername(String emailUsername) {
        this.emailUsername = emailUsername;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public void setEmailPort(Integer emailPort) {
        this.emailPort = emailPort;
    }

    public void setEmailSsl(boolean emailSsl) {
        this.emailSsl = emailSsl;
    }

    public void setEmailStarttls(boolean emailStarttls) {
        this.emailStarttls = emailStarttls;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailServerConfig)) {
            return false;
        }
        MailServerConfig other = (MailServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEmailSsl() != other.isEmailSsl()) {
            return false;
        }
        if (this.isEmailStarttls() != other.isEmailStarttls()) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$emailPort = this.getEmailPort();
        Integer other$emailPort = other.getEmailPort();
        if (this$emailPort == null ? other$emailPort != null : !((Object)this$emailPort).equals(other$emailPort)) {
            return false;
        }
        String this$emailHost = this.getEmailHost();
        String other$emailHost = other.getEmailHost();
        if (this$emailHost == null ? other$emailHost != null : !this$emailHost.equals(other$emailHost)) {
            return false;
        }
        String this$emailUsername = this.getEmailUsername();
        String other$emailUsername = other.getEmailUsername();
        if (this$emailUsername == null ? other$emailUsername != null : !this$emailUsername.equals(other$emailUsername)) {
            return false;
        }
        String this$emailPassword = this.getEmailPassword();
        String other$emailPassword = other.getEmailPassword();
        return !(this$emailPassword == null ? other$emailPassword != null : !this$emailPassword.equals(other$emailPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmailSsl() ? 79 : 97);
        result = result * 59 + (this.isEmailStarttls() ? 79 : 97);
        result = result * 59 + (this.isEnable() ? 79 : 97);
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $emailPort = this.getEmailPort();
        result = result * 59 + ($emailPort == null ? 43 : ((Object)$emailPort).hashCode());
        String $emailHost = this.getEmailHost();
        result = result * 59 + ($emailHost == null ? 43 : $emailHost.hashCode());
        String $emailUsername = this.getEmailUsername();
        result = result * 59 + ($emailUsername == null ? 43 : $emailUsername.hashCode());
        String $emailPassword = this.getEmailPassword();
        result = result * 59 + ($emailPassword == null ? 43 : $emailPassword.hashCode());
        return result;
    }

    public String toString() {
        return "MailServerConfig(type=" + this.getType() + ", emailHost=" + this.getEmailHost() + ", emailUsername=" + this.getEmailUsername() + ", emailPassword=" + this.getEmailPassword() + ", emailPort=" + this.getEmailPort() + ", emailSsl=" + this.isEmailSsl() + ", emailStarttls=" + this.isEmailStarttls() + ", enable=" + this.isEnable() + ")";
    }

    public MailServerConfig() {
    }

    public MailServerConfig(Integer type, String emailHost, String emailUsername, String emailPassword, Integer emailPort, boolean emailSsl, boolean emailStarttls, boolean enable) {
        this.type = type;
        this.emailHost = emailHost;
        this.emailUsername = emailUsername;
        this.emailPassword = emailPassword;
        this.emailPort = emailPort;
        this.emailSsl = emailSsl;
        this.emailStarttls = emailStarttls;
        this.enable = enable;
    }
}

