/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.rs.RestfulConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SchemalessWriter {
    protected Connection connection;

    public SchemalessWriter(Connection connection) {
        this.connection = connection;
    }

    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        if (!(this.connection instanceof TSDBConnection)) {
            if (this.connection instanceof RestfulConnection) {
                throw TSDBError.createSQLException(8962, "restful connection is not supported currently");
            }
            throw TSDBError.createSQLException(9040, "unknown connection\uff1a" + this.connection.getMetaData().getURL());
        }
        TSDBConnection tsdbConnection = (TSDBConnection)this.connection;
        tsdbConnection.getConnector().insertLines(lines, protocolType, timestampType);
    }

    public void write(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.write(new String[]{line}, protocolType, timestampType);
    }

    public void write(List<String> lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        String[] strings = lines.toArray(new String[0]);
        this.write(strings, protocolType, timestampType);
    }
}

