/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.opentelemetry.instrumentation.logback.mdc.v1_0.OpenTelemetryAppender;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;

class LogbackAppenderInstaller {
    static void install(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Optional<OpenTelemetryAppender> existingMdcAppender = LogbackAppenderInstaller.findAppender(OpenTelemetryAppender.class);
        if (existingMdcAppender.isPresent()) {
            LogbackAppenderInstaller.initializeMdcAppenderFromProperties(applicationEnvironmentPreparedEvent, existingMdcAppender.get());
        } else if (LogbackAppenderInstaller.isLogbackMdcAppenderAddable(applicationEnvironmentPreparedEvent)) {
            LogbackAppenderInstaller.addMdcAppender(applicationEnvironmentPreparedEvent);
        }
        Optional<io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender> existingOpenTelemetryAppender = LogbackAppenderInstaller.findAppender(io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender.class);
        if (existingOpenTelemetryAppender.isPresent()) {
            LogbackAppenderInstaller.reInitializeOpenTelemetryAppender(existingOpenTelemetryAppender, applicationEnvironmentPreparedEvent);
        } else if (LogbackAppenderInstaller.isLogbackAppenderAddable(applicationEnvironmentPreparedEvent)) {
            LogbackAppenderInstaller.addOpenTelemetryAppender(applicationEnvironmentPreparedEvent);
        }
    }

    private static boolean isLogbackAppenderAddable(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        return LogbackAppenderInstaller.isAppenderAddable(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.enabled");
    }

    private static boolean isLogbackMdcAppenderAddable(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        return LogbackAppenderInstaller.isAppenderAddable(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-mdc.enabled");
    }

    private static boolean isAppenderAddable(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, String property) {
        boolean otelSdkDisabled = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.sdk.disabled", false);
        boolean logbackInstrumentationEnabled = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, property, true);
        return !otelSdkDisabled && logbackInstrumentationEnabled;
    }

    private static void reInitializeOpenTelemetryAppender(Optional<io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender> existingOpenTelemetryAppender, ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender openTelemetryAppender = existingOpenTelemetryAppender.get();
        openTelemetryAppender.stop();
        LogbackAppenderInstaller.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
    }

    private static void addOpenTelemetryAppender(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Logger logger = (Logger)LoggerFactory.getILoggerFactory().getLogger("ROOT");
        io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender openTelemetryAppender = new io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender();
        LogbackAppenderInstaller.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
        logger.addAppender((Appender)openTelemetryAppender);
    }

    private static void initializeOpenTelemetryAppenderFromProperties(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender openTelemetryAppender) {
        String mdcAttributeProperty;
        Boolean captureLogstashAttributes;
        Boolean captureArguments;
        Boolean loggerContextAttributes;
        Boolean logAttributes;
        Boolean keyValuePairAttributes;
        Boolean markerAttribute;
        Boolean codeAttribute = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-code-attributes");
        if (codeAttribute != null) {
            openTelemetryAppender.setCaptureCodeAttributes(codeAttribute.booleanValue());
        }
        if ((markerAttribute = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-marker-attribute")) != null) {
            openTelemetryAppender.setCaptureMarkerAttribute(markerAttribute.booleanValue());
        }
        if ((keyValuePairAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-key-value-pair-attributes")) != null) {
            openTelemetryAppender.setCaptureKeyValuePairAttributes(keyValuePairAttributes.booleanValue());
        }
        if ((logAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental-log-attributes")) != null) {
            openTelemetryAppender.setCaptureExperimentalAttributes(logAttributes.booleanValue());
        }
        if ((loggerContextAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-logger-context-attributes")) != null) {
            openTelemetryAppender.setCaptureLoggerContext(loggerContextAttributes.booleanValue());
        }
        if ((captureArguments = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-arguments")) != null) {
            openTelemetryAppender.setCaptureArguments(captureArguments.booleanValue());
        }
        if ((captureLogstashAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-logstash-attributes")) != null) {
            openTelemetryAppender.setCaptureLogstashAttributes(captureLogstashAttributes.booleanValue());
        }
        if ((mdcAttributeProperty = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.logback-appender.experimental.capture-mdc-attributes", String.class)) != null) {
            openTelemetryAppender.setCaptureMdcAttributes(mdcAttributeProperty);
        }
    }

    private static void addMdcAppender(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Logger logger = (Logger)LoggerFactory.getILoggerFactory().getLogger("ROOT");
        OpenTelemetryAppender openTelemetryAppender = new OpenTelemetryAppender();
        LogbackAppenderInstaller.initializeMdcAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
        logger.addAppender((Appender)openTelemetryAppender);
        Iterator i = logger.iteratorForAppenders();
        while (i.hasNext()) {
            Appender appender = (Appender)i.next();
            if (appender == openTelemetryAppender) continue;
            openTelemetryAppender.addAppender(appender);
            logger.detachAppender(appender);
        }
    }

    private static void initializeMdcAppenderFromProperties(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, OpenTelemetryAppender openTelemetryAppender) {
        String traceFlagsKey;
        String spanIdKey;
        String traceIdKey;
        Boolean addBaggage = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-mdc.add-baggage");
        if (addBaggage != null) {
            openTelemetryAppender.setAddBaggage(addBaggage.booleanValue());
        }
        if ((traceIdKey = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.common.logging.trace-id", String.class)) != null) {
            openTelemetryAppender.setTraceIdKey(traceIdKey);
        }
        if ((spanIdKey = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.common.logging.span-id", String.class)) != null) {
            openTelemetryAppender.setSpanIdKey(spanIdKey);
        }
        if ((traceFlagsKey = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.common.logging.trace-flags", String.class)) != null) {
            openTelemetryAppender.setTraceFlagsKey(traceFlagsKey);
        }
    }

    private static Boolean evaluateBooleanProperty(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, String property) {
        return (Boolean)applicationEnvironmentPreparedEvent.getEnvironment().getProperty(property, Boolean.class);
    }

    private static boolean evaluateBooleanProperty(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, String property, boolean defaultValue) {
        return (Boolean)applicationEnvironmentPreparedEvent.getEnvironment().getProperty(property, Boolean.class, (Object)defaultValue);
    }

    private static <T> Optional<T> findAppender(Class<T> appenderClass) {
        ILoggerFactory loggerFactorySpi = LoggerFactory.getILoggerFactory();
        if (!(loggerFactorySpi instanceof LoggerContext)) {
            return Optional.empty();
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactorySpi;
        for (Logger logger : loggerContext.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                if (!appenderClass.isInstance(appender)) continue;
                T openTelemetryAppender = appenderClass.cast(appender);
                return Optional.of(openTelemetryAppender);
            }
        }
        return Optional.empty();
    }

    private LogbackAppenderInstaller() {
    }
}

