/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.functions;

import java.util.function.Function;
import java.util.stream.IntStream;

public final class Log10RootFunction
implements Function<Integer, Integer> {
    static final int[] lookup = new int[1000];
    private static final Log10RootFunction INSTANCE;

    public static Function<Integer, Integer> create(int baseline) {
        return INSTANCE.andThen(t -> t + baseline);
    }

    @Override
    public Integer apply(Integer t) {
        return t < 1000 ? lookup[t] : (int)Math.log10(t.intValue());
    }

    static {
        IntStream.range(0, 1000).forEach(i -> {
            Log10RootFunction.lookup[i] = Math.max(1, (int)Math.log10(i));
        });
        INSTANCE = new Log10RootFunction();
    }
}

