/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.KeyValue;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class KeyValueListScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, List<ScoredValue<V>>>> {
    private K key;
    private V value;
    private double score;
    private List<ScoredValue<V>> items = new ArrayList<ScoredValue<V>>();

    public KeyValueListScoredValueOutput(RedisCodec<K, V> codec, K defaultKey) {
        super(codec, KeyValue.empty(defaultKey));
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (this.key == null) {
                this.key = this.codec.decodeKey(bytes);
                return;
            }
            if (this.value == null) {
                this.value = this.codec.decodeValue(bytes);
                return;
            }
            this.score = Double.parseDouble(this.decodeAscii(bytes));
        }
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            this.score = number;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 2) {
            this.items.add(ScoredValue.just(this.score, this.value));
            this.value = null;
        }
        if (depth == 0 && this.key != null) {
            this.output = KeyValue.just(this.key, this.items);
        }
    }
}

