/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxServerTelemetryBuilder;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.TelemetryProducingWebFilter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;

public final class SpringWebfluxServerTelemetry {
    private final Instrumenter<ServerWebExchange, ServerWebExchange> serverInstrumenter;

    public static SpringWebfluxServerTelemetry create(OpenTelemetry openTelemetry) {
        return SpringWebfluxServerTelemetry.builder(openTelemetry).build();
    }

    public static SpringWebfluxServerTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringWebfluxServerTelemetryBuilder(openTelemetry);
    }

    SpringWebfluxServerTelemetry(Instrumenter<ServerWebExchange, ServerWebExchange> serverInstrumenter) {
        this.serverInstrumenter = serverInstrumenter;
    }

    public WebFilter createWebFilter() {
        return new TelemetryProducingWebFilter(this.serverInstrumenter);
    }

    public WebFilter createWebFilterAndRegisterReactorHook() {
        SpringWebfluxServerTelemetry.registerReactorHook();
        return this.createWebFilter();
    }

    private static void registerReactorHook() {
        ContextPropagationOperator.builder().build().registerOnEachOperator();
    }
}

