/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.MeasurementGroup;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Schema
implements Serializable {
    private final Map<Path, MeasurementGroup> registeredTimeseries;
    private Map<String, MeasurementGroup> schemaTemplates;

    public Schema() {
        this.registeredTimeseries = new LinkedHashMap<Path, MeasurementGroup>();
    }

    public Schema(Map<Path, MeasurementGroup> knownSchema) {
        this.registeredTimeseries = knownSchema;
    }

    public void registerTimeseries(Path devicePath, MeasurementSchema measurementSchema) {
        MeasurementGroup group = this.registeredTimeseries.getOrDefault(devicePath, new MeasurementGroup(false));
        group.getMeasurementSchemaMap().put(measurementSchema.getMeasurementId(), measurementSchema);
        this.registeredTimeseries.put(devicePath, group);
    }

    public void registerMeasurementGroup(Path devicePath, MeasurementGroup measurementGroup) {
        this.registeredTimeseries.put(devicePath, measurementGroup);
    }

    public void registerSchemaTemplate(String templateName, MeasurementGroup measurementGroup) {
        if (this.schemaTemplates == null) {
            this.schemaTemplates = new HashMap<String, MeasurementGroup>();
        }
        this.schemaTemplates.put(templateName, measurementGroup);
    }

    public void extendTemplate(String templateName, MeasurementSchema descriptor) {
        if (this.schemaTemplates == null) {
            this.schemaTemplates = new HashMap<String, MeasurementGroup>();
        }
        MeasurementGroup measurementGroup = this.schemaTemplates.getOrDefault(templateName, new MeasurementGroup(false, new HashMap<String, MeasurementSchema>()));
        measurementGroup.getMeasurementSchemaMap().put(descriptor.getMeasurementId(), descriptor);
        this.schemaTemplates.put(templateName, measurementGroup);
    }

    public void registerDevice(String deviceId, String templateName) {
        if (!this.schemaTemplates.containsKey(templateName)) {
            return;
        }
        Map<String, MeasurementSchema> template = this.schemaTemplates.get(templateName).getMeasurementSchemaMap();
        boolean isAligned = this.schemaTemplates.get(templateName).isAligned();
        this.registerMeasurementGroup(new Path(deviceId), new MeasurementGroup(isAligned, template));
    }

    public MeasurementGroup getSeriesSchema(Path devicePath) {
        return this.registeredTimeseries.get(devicePath);
    }

    public Map<String, MeasurementGroup> getSchemaTemplates() {
        return this.schemaTemplates;
    }

    public boolean containsDevice(Path devicePath) {
        return this.registeredTimeseries.containsKey(devicePath);
    }

    public Map<Path, MeasurementGroup> getRegisteredTimeseriesMap() {
        return this.registeredTimeseries;
    }
}

